/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.aot.hint;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.security.aot.hint.AuthorizeReturnObjectHintsRegistrar;
import org.springframework.security.aot.hint.SecurityHintsRegistrar;
import org.springframework.security.authorization.AuthorizationProxyFactory;
import org.springframework.security.authorization.method.AuthorizeReturnObject;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanners;
import org.springframework.util.Assert;

public final class AuthorizeReturnObjectCoreHintsRegistrar
implements SecurityHintsRegistrar {
    private final AuthorizationProxyFactory proxyFactory;
    private final SecurityAnnotationScanner<AuthorizeReturnObject> scanner = SecurityAnnotationScanners.requireUnique(AuthorizeReturnObject.class);
    private final Set<Class<?>> visitedClasses = new HashSet();

    public AuthorizeReturnObjectCoreHintsRegistrar(AuthorizationProxyFactory proxyFactory) {
        Assert.notNull((Object)proxyFactory, (String)"proxyFactory cannot be null");
        this.proxyFactory = proxyFactory;
    }

    @Override
    public void registerHints(RuntimeHints hints, ConfigurableListableBeanFactory beanFactory) {
        ArrayList toProxy = new ArrayList();
        for (String name : beanFactory.getBeanDefinitionNames()) {
            Class clazz = beanFactory.getType(name, false);
            if (clazz == null) continue;
            for (Method method : clazz.getDeclaredMethods()) {
                AuthorizeReturnObject annotation = this.scanner.scan(method, clazz);
                if (annotation == null) continue;
                toProxy.add(method.getReturnType());
            }
        }
        new AuthorizeReturnObjectHintsRegistrar(this.proxyFactory, toProxy).registerHints(hints, beanFactory);
    }
}

