/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context;

import org.springframework.context.ApplicationEvent;
import org.springframework.core.ResolvableType;
import org.springframework.core.ResolvableTypeProvider;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class PayloadApplicationEvent<T>
extends ApplicationEvent
implements ResolvableTypeProvider {
    private final T payload;
    private final ResolvableType payloadType;

    public PayloadApplicationEvent(Object source, T payload) {
        this(source, payload, null);
    }

    public PayloadApplicationEvent(Object source, T payload, @Nullable ResolvableType payloadType) {
        super(source);
        Assert.notNull(payload, (String)"Payload must not be null");
        this.payload = payload;
        this.payloadType = payloadType != null ? payloadType : ResolvableType.forInstance(payload);
    }

    public ResolvableType getResolvableType() {
        return ResolvableType.forClassWithGenerics(this.getClass(), (ResolvableType[])new ResolvableType[]{this.payloadType});
    }

    public T getPayload() {
        return this.payload;
    }
}

