/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.saml2;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.core.Version;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.RequestMatcherFactory;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.saml2.Saml2LoginConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSaml4LogoutRequestValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSaml4LogoutResponseValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSaml5LogoutRequestValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.OpenSaml5LogoutResponseValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequestValidator;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutResponseValidator;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;
import org.springframework.security.saml2.provider.service.web.authentication.logout.HttpSessionLogoutRequestRepository;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml4LogoutRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml4LogoutRequestValidatorParametersResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml4LogoutResponseResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml5LogoutRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml5LogoutRequestValidatorParametersResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.OpenSaml5LogoutResponseResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestFilter;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestRepository;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutRequestValidatorParametersResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutResponseFilter;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2LogoutResponseResolver;
import org.springframework.security.saml2.provider.service.web.authentication.logout.Saml2RelyingPartyInitiatedLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessEventPublishingLogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.ParameterRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public final class Saml2LogoutConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<Saml2LogoutConfigurer<H>, H> {
    private static final boolean USE_OPENSAML_5 = Version.getVersion().startsWith("5");
    private ApplicationContext context;
    private RelyingPartyRegistrationRepository relyingPartyRegistrationRepository;
    private String logoutUrl = "/logout";
    private List<LogoutHandler> logoutHandlers = new ArrayList<LogoutHandler>();
    private LogoutSuccessHandler logoutSuccessHandler;
    private LogoutRequestConfigurer logoutRequestConfigurer;
    private LogoutResponseConfigurer logoutResponseConfigurer;

    public Saml2LogoutConfigurer(ApplicationContext context) {
        this.context = context;
        this.logoutHandlers.add((LogoutHandler)new SecurityContextLogoutHandler());
        this.logoutHandlers.add((LogoutHandler)new LogoutSuccessEventPublishingLogoutHandler());
        SimpleUrlLogoutSuccessHandler logoutSuccessHandler = new SimpleUrlLogoutSuccessHandler();
        logoutSuccessHandler.setDefaultTargetUrl("/login?logout");
        this.logoutSuccessHandler = logoutSuccessHandler;
        this.logoutRequestConfigurer = new LogoutRequestConfigurer();
        this.logoutResponseConfigurer = new LogoutResponseConfigurer();
    }

    public Saml2LogoutConfigurer<H> logoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
        return this;
    }

    public Saml2LogoutConfigurer<H> relyingPartyRegistrationRepository(RelyingPartyRegistrationRepository repo) {
        this.relyingPartyRegistrationRepository = repo;
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public LogoutRequestConfigurer logoutRequest() {
        return this.logoutRequestConfigurer;
    }

    public Saml2LogoutConfigurer<H> logoutRequest(Customizer<LogoutRequestConfigurer> logoutRequestConfigurerCustomizer) {
        logoutRequestConfigurerCustomizer.customize(this.logoutRequestConfigurer);
        return this;
    }

    @Deprecated(since="6.1", forRemoval=true)
    public LogoutResponseConfigurer logoutResponse() {
        return this.logoutResponseConfigurer;
    }

    public Saml2LogoutConfigurer<H> logoutResponse(Customizer<LogoutResponseConfigurer> logoutResponseConfigurerCustomizer) {
        logoutResponseConfigurerCustomizer.customize(this.logoutResponseConfigurer);
        return this;
    }

    @Override
    public void configure(H http) throws Exception {
        LogoutConfigurer logout = http.getConfigurer(LogoutConfigurer.class);
        if (logout != null) {
            this.logoutHandlers = logout.getLogoutHandlers();
            this.logoutSuccessHandler = logout.getLogoutSuccessHandler();
        }
        RelyingPartyRegistrationRepository registrations = this.getRelyingPartyRegistrationRepository(http);
        http.addFilterBefore((Filter)this.createLogoutRequestProcessingFilter(registrations), CsrfFilter.class);
        http.addFilterBefore((Filter)this.createLogoutResponseProcessingFilter(registrations), CsrfFilter.class);
        http.addFilterBefore((Filter)this.createRelyingPartyLogoutFilter(registrations), LogoutFilter.class);
    }

    private RelyingPartyRegistrationRepository getRelyingPartyRegistrationRepository(H http) {
        if (this.relyingPartyRegistrationRepository != null) {
            return this.relyingPartyRegistrationRepository;
        }
        Saml2LoginConfigurer login = http.getConfigurer(Saml2LoginConfigurer.class);
        this.relyingPartyRegistrationRepository = login != null ? login.relyingPartyRegistrationRepository(http) : this.getBeanOrNull(RelyingPartyRegistrationRepository.class);
        return this.relyingPartyRegistrationRepository;
    }

    private Saml2LogoutRequestFilter createLogoutRequestProcessingFilter(RelyingPartyRegistrationRepository registrations) {
        LogoutHandler[] logoutHandlers = this.logoutHandlers.toArray(new LogoutHandler[0]);
        Saml2LogoutResponseResolver logoutResponseResolver = this.createSaml2LogoutResponseResolver(registrations);
        Saml2LogoutRequestFilter filter = new Saml2LogoutRequestFilter(this.createSaml2LogoutResponseParametersResolver(registrations), this.logoutRequestConfigurer.logoutRequestValidator(), logoutResponseResolver, logoutHandlers);
        filter.setSecurityContextHolderStrategy(this.getSecurityContextHolderStrategy());
        return this.postProcess(filter);
    }

    private Saml2LogoutRequestValidatorParametersResolver createSaml2LogoutResponseParametersResolver(RelyingPartyRegistrationRepository registrations) {
        RequestMatcher requestMatcher = this.createLogoutRequestMatcher();
        if (USE_OPENSAML_5) {
            OpenSaml5LogoutRequestValidatorParametersResolver parameters = new OpenSaml5LogoutRequestValidatorParametersResolver(registrations);
            parameters.setRequestMatcher(requestMatcher);
            return parameters;
        }
        OpenSaml4LogoutRequestValidatorParametersResolver parameters = new OpenSaml4LogoutRequestValidatorParametersResolver(registrations);
        parameters.setRequestMatcher(requestMatcher);
        return parameters;
    }

    private Saml2LogoutResponseFilter createLogoutResponseProcessingFilter(RelyingPartyRegistrationRepository registrations) {
        Saml2LogoutResponseFilter logoutResponseFilter = new Saml2LogoutResponseFilter(registrations, this.logoutResponseConfigurer.logoutResponseValidator(), this.logoutSuccessHandler);
        logoutResponseFilter.setLogoutRequestMatcher(this.createLogoutResponseMatcher());
        logoutResponseFilter.setLogoutRequestRepository(this.logoutRequestConfigurer.logoutRequestRepository);
        return this.postProcess(logoutResponseFilter);
    }

    private Saml2RelyingPartyInitiatedLogoutFilter createRelyingPartyLogoutFilter(RelyingPartyRegistrationRepository registrations) {
        LogoutHandler[] logoutHandlers = this.logoutHandlers.toArray(new LogoutHandler[0]);
        Saml2RelyingPartyInitiatedLogoutSuccessHandler logoutRequestSuccessHandler = this.createSaml2LogoutRequestSuccessHandler(registrations);
        logoutRequestSuccessHandler.setLogoutRequestRepository(this.logoutRequestConfigurer.logoutRequestRepository);
        Saml2RelyingPartyInitiatedLogoutFilter logoutFilter = new Saml2RelyingPartyInitiatedLogoutFilter((LogoutSuccessHandler)logoutRequestSuccessHandler, logoutHandlers);
        logoutFilter.setLogoutRequestMatcher(this.createLogoutMatcher());
        return this.postProcess(logoutFilter);
    }

    private RequestMatcher createLogoutMatcher() {
        RequestMatcher logout = RequestMatcherFactory.matcher(HttpMethod.POST, this.logoutUrl);
        Saml2RequestMatcher saml2 = new Saml2RequestMatcher(this.getSecurityContextHolderStrategy());
        return new AndRequestMatcher(new RequestMatcher[]{logout, saml2});
    }

    private RequestMatcher createLogoutRequestMatcher() {
        RequestMatcher logout = RequestMatcherFactory.matcher(this.logoutRequestConfigurer.logoutUrl);
        ParameterRequestMatcher samlRequest = new ParameterRequestMatcher("SAMLRequest");
        return new AndRequestMatcher(new RequestMatcher[]{logout, samlRequest});
    }

    private RequestMatcher createLogoutResponseMatcher() {
        RequestMatcher logout = RequestMatcherFactory.matcher(this.logoutResponseConfigurer.logoutUrl);
        ParameterRequestMatcher samlResponse = new ParameterRequestMatcher("SAMLResponse");
        return new AndRequestMatcher(new RequestMatcher[]{logout, samlResponse});
    }

    private Saml2RelyingPartyInitiatedLogoutSuccessHandler createSaml2LogoutRequestSuccessHandler(RelyingPartyRegistrationRepository registrations) {
        Saml2LogoutRequestResolver logoutRequestResolver = this.logoutRequestConfigurer.logoutRequestResolver(registrations);
        return new Saml2RelyingPartyInitiatedLogoutSuccessHandler(logoutRequestResolver);
    }

    private Saml2LogoutResponseResolver createSaml2LogoutResponseResolver(RelyingPartyRegistrationRepository registrations) {
        return this.logoutResponseConfigurer.logoutResponseResolver(registrations);
    }

    private <C> C getBeanOrNull(Class<C> clazz) {
        if (this.context == null) {
            return null;
        }
        return (C)this.context.getBeanProvider(clazz).getIfAvailable();
    }

    public final class LogoutRequestConfigurer {
        private String logoutUrl = "/logout/saml2/slo";
        private Saml2LogoutRequestValidator logoutRequestValidator;
        private Saml2LogoutRequestResolver logoutRequestResolver;
        private Saml2LogoutRequestRepository logoutRequestRepository = new HttpSessionLogoutRequestRepository();

        LogoutRequestConfigurer() {
        }

        public LogoutRequestConfigurer logoutUrl(String logoutUrl) {
            this.logoutUrl = logoutUrl;
            return this;
        }

        public LogoutRequestConfigurer logoutRequestValidator(Saml2LogoutRequestValidator authenticator) {
            this.logoutRequestValidator = authenticator;
            return this;
        }

        public LogoutRequestConfigurer logoutRequestResolver(Saml2LogoutRequestResolver logoutRequestResolver) {
            this.logoutRequestResolver = logoutRequestResolver;
            return this;
        }

        public LogoutRequestConfigurer logoutRequestRepository(Saml2LogoutRequestRepository logoutRequestRepository) {
            this.logoutRequestRepository = logoutRequestRepository;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public Saml2LogoutConfigurer<H> and() {
            return Saml2LogoutConfigurer.this;
        }

        private Saml2LogoutRequestValidator logoutRequestValidator() {
            if (this.logoutRequestValidator != null) {
                return this.logoutRequestValidator;
            }
            if (USE_OPENSAML_5) {
                return new OpenSaml5LogoutRequestValidator();
            }
            return new OpenSaml4LogoutRequestValidator();
        }

        private Saml2LogoutRequestResolver logoutRequestResolver(RelyingPartyRegistrationRepository registrations) {
            if (this.logoutRequestResolver != null) {
                return this.logoutRequestResolver;
            }
            if (USE_OPENSAML_5) {
                return new OpenSaml5LogoutRequestResolver(registrations);
            }
            return new OpenSaml4LogoutRequestResolver(registrations);
        }
    }

    public final class LogoutResponseConfigurer {
        private String logoutUrl = "/logout/saml2/slo";
        private Saml2LogoutResponseValidator logoutResponseValidator;
        private Saml2LogoutResponseResolver logoutResponseResolver;

        LogoutResponseConfigurer() {
        }

        public LogoutResponseConfigurer logoutUrl(String logoutUrl) {
            this.logoutUrl = logoutUrl;
            return this;
        }

        public LogoutResponseConfigurer logoutResponseValidator(Saml2LogoutResponseValidator authenticator) {
            this.logoutResponseValidator = authenticator;
            return this;
        }

        public LogoutResponseConfigurer logoutResponseResolver(Saml2LogoutResponseResolver logoutResponseResolver) {
            this.logoutResponseResolver = logoutResponseResolver;
            return this;
        }

        @Deprecated(since="6.1", forRemoval=true)
        public Saml2LogoutConfigurer<H> and() {
            return Saml2LogoutConfigurer.this;
        }

        private Saml2LogoutResponseValidator logoutResponseValidator() {
            if (this.logoutResponseValidator != null) {
                return this.logoutResponseValidator;
            }
            if (USE_OPENSAML_5) {
                return new OpenSaml5LogoutResponseValidator();
            }
            return new OpenSaml4LogoutResponseValidator();
        }

        private Saml2LogoutResponseResolver logoutResponseResolver(RelyingPartyRegistrationRepository registrations) {
            if (this.logoutResponseResolver != null) {
                return this.logoutResponseResolver;
            }
            if (USE_OPENSAML_5) {
                return new OpenSaml5LogoutResponseResolver(registrations);
            }
            return new OpenSaml4LogoutResponseResolver(registrations);
        }
    }

    private static class Saml2RelyingPartyInitiatedLogoutFilter
    extends LogoutFilter {
        Saml2RelyingPartyInitiatedLogoutFilter(LogoutSuccessHandler logoutSuccessHandler, LogoutHandler ... handlers) {
            super(logoutSuccessHandler, handlers);
        }
    }

    private static class Saml2RequestMatcher
    implements RequestMatcher {
        private final SecurityContextHolderStrategy securityContextHolderStrategy;

        Saml2RequestMatcher(SecurityContextHolderStrategy securityContextHolderStrategy) {
            this.securityContextHolderStrategy = securityContextHolderStrategy;
        }

        public boolean matches(HttpServletRequest request) {
            Authentication authentication = this.securityContextHolderStrategy.getContext().getAuthentication();
            if (authentication == null) {
                return false;
            }
            return authentication.getPrincipal() instanceof Saml2AuthenticatedPrincipal;
        }
    }
}

