/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stream.io.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.nio.BufferOverflowException;

public abstract class AbstractTextDemarcator
implements Closeable {
    private static final int INIT_BUFFER_SIZE = 8192;
    private final Reader reader;
    private final int maxDataSize;
    char[] buffer;
    int index;
    int mark;
    int availableBytesLength;

    AbstractTextDemarcator(Reader reader, int maxDataSize) {
        this(reader, maxDataSize, 8192);
    }

    AbstractTextDemarcator(Reader reader, int maxDataSize, int initialBufferSize) {
        this.validate(reader, maxDataSize, initialBufferSize);
        this.reader = reader;
        this.buffer = new char[initialBufferSize];
        this.maxDataSize = maxDataSize;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    void fill() throws IOException {
        int bytesRead;
        if (this.index >= this.buffer.length) {
            if (this.mark == 0) {
                long expandedSize = Math.min(this.buffer.length * 2, this.buffer.length + 0x100000);
                if (expandedSize > (long)this.maxDataSize) {
                    throw new BufferOverflowException();
                }
                char[] newBuff = new char[(int)expandedSize];
                System.arraycopy(this.buffer, 0, newBuff, 0, this.buffer.length);
                this.buffer = newBuff;
            } else {
                int length = this.index - this.mark;
                System.arraycopy(this.buffer, this.mark, this.buffer, 0, length);
                this.index = length;
                this.mark = 0;
            }
        }
        while ((bytesRead = this.reader.read(this.buffer, this.index, this.buffer.length - this.index)) == 0) {
        }
        this.availableBytesLength = bytesRead != -1 ? this.index + bytesRead : -1;
    }

    private void validate(Reader reader, int maxDataSize, int initialBufferSize) {
        if (reader == null) {
            throw new IllegalArgumentException("'reader' must not be null");
        }
        if (maxDataSize <= 0) {
            throw new IllegalArgumentException("'maxDataSize' must be > 0");
        }
        if (initialBufferSize <= 0) {
            throw new IllegalArgumentException("'initialBufferSize' must be > 0");
        }
    }
}

