/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ant.AntBasedProjectFactorySingleton;
import org.netbeans.modules.project.ant.ProjectLibraryProvider;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectGenerator {
    private ProjectGenerator() {
    }

    public static AntProjectHelper createProject(FileObject directory, String type) throws IOException, IllegalArgumentException {
        return ProjectGenerator.createProject0(directory, type, null, null);
    }

    public static AntProjectHelper createProject(FileObject directory, String type, String librariesDefinition) throws IOException, IllegalArgumentException {
        return ProjectGenerator.createProject0(directory, type, null, librariesDefinition);
    }

    private static AntProjectHelper createProject0(final FileObject directory, final String type, final String name, final String librariesDefinition) throws IOException, IllegalArgumentException {
        try {
            return ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<AntProjectHelper>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public AntProjectHelper run() throws IOException {
                    Project p;
                    directory.refresh();
                    FileObject projectXml = directory.getFileObject("nbproject/project.xml");
                    if (projectXml != null) {
                        throw new IllegalArgumentException("Already a " + projectXml);
                    }
                    Project prj = ProjectManager.getDefault().findProject(directory);
                    if (prj != null) {
                        AntProjectHelper h;
                        if (ProjectConvertors.isConvertorProject(prj)) {
                            ProjectConvertors.unregisterConvertorProject(prj);
                            prj = null;
                        } else if (prj.getProjectDirectory().getChildren().length == 0 && (h = AntBasedProjectFactorySingleton.getHelperFor(prj)) != null) {
                            h.notifyDeleted();
                            prj = ProjectManager.getDefault().findProject(directory);
                        }
                    }
                    if (prj != null) {
                        throw new IllegalArgumentException("Already a " + prj.getClass().getName() + " in " + directory);
                    }
                    projectXml = FileUtil.createData(directory, "nbproject/project.xml");
                    Document doc = XMLUtil.createDocument("project", "http://www.netbeans.org/ns/project/1", null, null);
                    Element el = doc.createElementNS("http://www.netbeans.org/ns/project/1", "type");
                    el.appendChild(doc.createTextNode(type));
                    doc.getDocumentElement().appendChild(el);
                    if (name != null) {
                        el = doc.createElementNS("http://www.netbeans.org/ns/project/1", "name");
                        el.appendChild(doc.createTextNode(name));
                        doc.getDocumentElement().appendChild(el);
                    }
                    el = doc.createElementNS("http://www.netbeans.org/ns/project/1", "configuration");
                    doc.getDocumentElement().appendChild(el);
                    if (librariesDefinition != null) {
                        el.appendChild(ProjectLibraryProvider.createLibrariesElement(doc, librariesDefinition));
                        File f = new File(librariesDefinition);
                        if (!f.isAbsolute()) {
                            f = new File(FileUtil.toFile(directory), librariesDefinition);
                        }
                        if (!(f = FileUtil.normalizeFile(f)).exists()) {
                            FileUtil.createData(f);
                        }
                    }
                    try (OutputStream os = projectXml.getOutputStream();){
                        XMLUtil.write(doc, os, "UTF-8");
                    }
                    ProjectManager.getDefault().clearNonProjectCache();
                    ByteArrayOutputStream diagStream = new ByteArrayOutputStream();
                    if (System.getProperty("java.class.path").contains("junit")) {
                        diagStream.write(58);
                        diagStream.write(10);
                        Iterator<AntBasedProjectType> diagHandler = new StreamHandler(diagStream, new SimpleFormatter());
                        ((Handler)((Object)diagHandler)).setLevel(Level.ALL);
                        Level oldLevel = AntBasedProjectFactorySingleton.LOG.getLevel();
                        AntBasedProjectFactorySingleton.LOG.setLevel(Level.ALL);
                        AntBasedProjectFactorySingleton.LOG.addHandler((Handler)((Object)diagHandler));
                        try {
                            p = ProjectManager.getDefault().findProject(directory);
                        }
                        finally {
                            AntBasedProjectFactorySingleton.LOG.removeHandler((Handler)((Object)diagHandler));
                            AntBasedProjectFactorySingleton.LOG.setLevel(oldLevel);
                            ((Handler)((Object)diagHandler)).close();
                        }
                    } else {
                        p = ProjectManager.getDefault().findProject(directory);
                    }
                    if (p == null) {
                        for (AntBasedProjectType abpt : Lookup.getDefault().lookupAll(AntBasedProjectType.class)) {
                            if (!abpt.getType().equals(type)) continue;
                            throw new IllegalArgumentException("For some reason the folder " + directory + " with a new project of type " + type + " is still not recognized" + diagStream);
                        }
                        for (AntBasedProjectType abpt : Lookups.forPath("Services").lookupAll(AntBasedProjectType.class)) {
                            if (!abpt.getType().equals(type)) continue;
                            throw new IllegalArgumentException("Factory type " + type + " is in Services lookup but not global");
                        }
                        if (FileUtil.getConfigFile("Services/AntBasedProjectTypes/" + type.replace('.', '-') + ".instance") != null) {
                            throw new IllegalArgumentException("Factory type " + type + " is registered but does not appear in lookup");
                        }
                        FileObject services = FileUtil.getConfigFile("Services");
                        if (services == null) {
                            FileObject r = FileUtil.getConfigRoot();
                            throw new IllegalArgumentException("No Services folder; SFS " + r.getFileSystem() + " contains: " + Collections.list(r.getChildren(true)));
                        }
                        throw new IllegalArgumentException("No Ant-based project factory for type " + type + "; Services folder contains: " + Collections.list(services.getChildren(true)));
                    }
                    AntProjectHelper helper = AntBasedProjectFactorySingleton.getHelperFor(p);
                    if (helper == null) {
                        throw new IllegalArgumentException("Project " + p + " was not recognized as an Ant-based project");
                    }
                    helper.markModified();
                    return helper;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
    }
}

