/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.parser;

import java.nio.CharBuffer;
import jpt.sun.tools.javac.code.Lint;
import jpt.sun.tools.javac.code.Preview;
import jpt.sun.tools.javac.code.Source;
import jpt.sun.tools.javac.main.Option;
import jpt.sun.tools.javac.parser.JavadocTokenizer;
import jpt.sun.tools.javac.parser.Scanner;
import jpt.sun.tools.javac.parser.Tokens;
import jpt.sun.tools.javac.util.Context;
import jpt.sun.tools.javac.util.Log;
import jpt.sun.tools.javac.util.Names;
import jpt.sun.tools.javac.util.Options;

public class ScannerFactory {
    public static final Context.Key<ScannerFactory> scannerFactoryKey = new Context.Key();
    final Log log;
    final Names names;
    final Source source;
    final Preview preview;
    final Tokens tokens;
    final Lint lint;
    final boolean enableLineDocComments;

    public static ScannerFactory instance(Context context) {
        ScannerFactory instance = context.get(scannerFactoryKey);
        if (instance == null) {
            instance = new ScannerFactory(context);
        }
        return instance;
    }

    protected ScannerFactory(Context context) {
        context.put(scannerFactoryKey, this);
        this.log = Log.instance(context);
        this.names = Names.instance(context);
        this.source = Source.instance(context);
        this.preview = Preview.instance(context);
        this.tokens = Tokens.instance(context);
        this.lint = Lint.instance(context);
        Options options = Options.instance(context);
        this.enableLineDocComments = !options.isSet(Option.DISABLE_LINE_DOC_COMMENTS);
    }

    public Scanner newScanner(CharSequence input, boolean keepDocComments) {
        if (input instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)input;
            if (keepDocComments) {
                return new Scanner(this, new JavadocTokenizer(this, charBuffer));
            }
            return new Scanner(this, charBuffer);
        }
        char[] array = input.toString().toCharArray();
        return this.newScanner(array, array.length, keepDocComments);
    }

    public Scanner newScanner(char[] input, int inputLength, boolean keepDocComments) {
        if (keepDocComments) {
            return new Scanner(this, new JavadocTokenizer(this, input, inputLength));
        }
        return new Scanner(this, input, inputLength);
    }
}

