/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.internal.component.AbstractUILabel;
import org.apache.myfaces.tobago.internal.component.AbstractUISeparator;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;

public class SeparatorRenderer<T extends AbstractUISeparator>
extends RendererBase<T> {
    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String clientId = component.getClientId(facesContext);
        writer.startElement(HtmlElements.TOBAGO_SEPARATOR);
        writer.writeIdAttribute(clientId);
        if (this.isInside(facesContext, HtmlElements.COMMAND)) {
            writer.writeClassAttribute(BootstrapClass.DROPDOWN_DIVIDER, component.getCustomClass());
        } else {
            writer.writeClassAttribute(component.getCustomClass());
            writer.startElement(HtmlElements.HR);
            writer.endElement(HtmlElements.HR);
            String label = this.getLabel((AbstractUISeparator)component);
            if (label != null) {
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute(TobagoClass.LABEL);
                writer.writeText(label);
                writer.endElement(HtmlElements.DIV);
                writer.startElement(HtmlElements.HR);
                writer.endElement(HtmlElements.HR);
            }
        }
        writer.endElement(HtmlElements.TOBAGO_SEPARATOR);
    }

    private String getLabel(AbstractUISeparator separator) {
        String label = separator.getLabel();
        UIComponent facet = ComponentUtils.getFacet((UIComponent)separator, Facets.label);
        if (label == null && facet != null) {
            label = String.valueOf(((AbstractUILabel)facet).getValue());
        }
        return label;
    }
}

