/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.tools.internal.freemarker.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public final class FreeMarkerUtils {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final String CHARSET_NAME = CHARSET.name();
    private static final Version CONFIGURATION_VERSION = Configuration.VERSION_2_3_29;

    private FreeMarkerUtils() {
    }

    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    private static Configuration createConfiguration(Path templateDirectory) {
        Configuration configuration = new Configuration(CONFIGURATION_VERSION);
        configuration.setDefaultEncoding(CHARSET_NAME);
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        try {
            configuration.setTemplateLoader((TemplateLoader)new FileTemplateLoader(templateDirectory.toFile()));
        }
        catch (IOException error) {
            throw new UncheckedIOException(error);
        }
        DefaultObjectWrapperBuilder objectWrapperBuilder = new DefaultObjectWrapperBuilder(CONFIGURATION_VERSION);
        objectWrapperBuilder.setExposeFields(true);
        DefaultObjectWrapper objectWrapper = objectWrapperBuilder.build();
        configuration.setObjectWrapper((ObjectWrapper)objectWrapper);
        configuration.setLogTemplateExceptions(false);
        configuration.setWrapUncheckedExceptions(true);
        configuration.setFallbackOnNullLoopVariable(false);
        return configuration;
    }

    @SuppressFBWarnings(value={"TEMPLATE_INJECTION_FREEMARKER"})
    public static void render(Path templateDirectory, String templateName, Object templateData, Path outputFile) {
        try {
            Configuration configuration = FreeMarkerUtils.createConfiguration(templateDirectory);
            Template template = configuration.getTemplate(templateName);
            StringWriter templateOutputWriter = new StringWriter();
            template.process(templateData, (Writer)templateOutputWriter);
            String templateOutput = templateOutputWriter.toString();
            Path outputFileParent = outputFile.getParent();
            if (outputFileParent != null) {
                Files.createDirectories(outputFileParent, new FileAttribute[0]);
            }
            try (BufferedWriter outputFileWriter = Files.newBufferedWriter(outputFile, CHARSET, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                outputFileWriter.write(templateOutput);
            }
        }
        catch (Exception error) {
            String message = String.format("failed rendering template `%s` in directory `%s` to file `%s`", templateName, templateDirectory, outputFile);
            throw new RuntimeException(message, error);
        }
    }

    @SuppressFBWarnings(value={"TEMPLATE_INJECTION_FREEMARKER"})
    public static String renderString(String templateString, Object templateData) {
        Configuration configuration = new Configuration(CONFIGURATION_VERSION);
        DefaultObjectWrapperBuilder objectWrapperBuilder = new DefaultObjectWrapperBuilder(CONFIGURATION_VERSION);
        objectWrapperBuilder.setExposeFields(true);
        DefaultObjectWrapper objectWrapper = objectWrapperBuilder.build();
        configuration.setObjectWrapper((ObjectWrapper)objectWrapper);
        try {
            Template template = new Template("ephemeralInlineTemplate", (Reader)new StringReader(templateString), configuration);
            StringWriter templateWriter = new StringWriter();
            template.process(templateData, (Writer)templateWriter);
            return ((Object)templateWriter).toString();
        }
        catch (Exception error) {
            String message = String.format("failed rendering template `%s`", templateString);
            throw new RuntimeException(message, error);
        }
    }
}

