/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.controller;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.api.Constraint;
import org.apache.logging.log4j.catalog.jpa.model.ConstraintModel;
import org.apache.logging.log4j.catalog.jpa.service.ConstraintService;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/constraints"})
@RestController
public class ConstraintController {
    private static final Logger LOGGER = LogManager.getLogger();
    private ModelMapper modelMapper = new ModelMapper();
    @Autowired
    private ConstraintService constraintService;

    @PostMapping(value={"/list"})
    public ResponseEntity<Map<String, Object>> attributeList(@RequestParam(value="attributeId") Long attributeId) {
        Type listType = new /* Unavailable Anonymous Inner Class!! */.getType();
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            ArrayList attributes = (ArrayList)this.modelMapper.map((Object)this.constraintService.getConstraints(), listType);
            if (attributes == null) {
                attributes = new ArrayList();
            }
            response.put("Result", "OK");
            response.put("Records", attributes);
        }
        catch (Exception ex) {
            response.put("Result", "FAILURE");
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @GetMapping(value={"/types"})
    public ResponseEntity<Set<String>> getConstraintTypes() {
        return new ResponseEntity((Object)this.constraintService.getConstraintTypes(), HttpStatus.OK);
    }

    @PostMapping(value={"/constraint"})
    public ResponseEntity<Long> addConstraint(@RequestBody Constraint constraint) {
        ConstraintModel model = (ConstraintModel)this.modelMapper.map((Object)constraint, ConstraintModel.class);
        model = this.constraintService.saveConstraint(model);
        return new ResponseEntity((Object)model.getId(), HttpStatus.CREATED);
    }

    @PutMapping(value={"/constraint/{id}"})
    public ResponseEntity<Long> updateConstraint(@RequestParam Long id, @RequestBody Constraint constraint) {
        ConstraintModel model = (ConstraintModel)this.modelMapper.map((Object)constraint, ConstraintModel.class);
        model.setId(id);
        model = this.constraintService.saveConstraint(model);
        return new ResponseEntity((Object)model.getId(), HttpStatus.OK);
    }

    @DeleteMapping(value={"/constraint/{id}"})
    public ResponseEntity<?> deleteConstraint(@RequestParam Long id) {
        this.constraintService.deleteConstraint(id);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

