/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.simple;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.knox.gateway.topology.simple.SimpleDescriptor;
import org.apache.knox.gateway.topology.simple.SimpleDescriptorImpl;

public class SimpleDescriptorFactory {
    public static SimpleDescriptor parse(String path) throws IOException {
        SimpleDescriptor sd;
        if (path.endsWith(".json")) {
            sd = SimpleDescriptorFactory.parseJSON(path);
        } else if (path.endsWith(".yml") || path.endsWith(".yaml")) {
            sd = SimpleDescriptorFactory.parseYAML(path);
        } else {
            throw new IllegalArgumentException("Unsupported simple descriptor format: " + path.substring(path.lastIndexOf(46)));
        }
        return sd;
    }

    static SimpleDescriptor parseJSON(String path) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleDescriptorImpl sd = (SimpleDescriptorImpl)mapper.readValue(new File(path), SimpleDescriptorImpl.class);
        if (sd != null) {
            sd.setName(FilenameUtils.getBaseName((String)path));
        }
        return sd;
    }

    static SimpleDescriptor parseYAML(String path) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        SimpleDescriptorImpl sd = (SimpleDescriptorImpl)mapper.readValue(new File(path), SimpleDescriptorImpl.class);
        if (sd != null) {
            sd.setName(FilenameUtils.getBaseName((String)path));
        }
        return sd;
    }
}

