/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.mavibot.btree.RevisionOffset;
import org.apache.directory.mavibot.btree.RevisionOffsetComparator;
import org.apache.directory.mavibot.btree.exception.SerializerCreationException;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;
import org.apache.directory.mavibot.btree.serializer.LongArraySerializer;
import org.apache.directory.mavibot.btree.serializer.LongSerializer;

class RevisionOffsetSerializer
extends AbstractElementSerializer<RevisionOffset> {
    static final RevisionOffsetSerializer INSTANCE = new RevisionOffsetSerializer();

    private RevisionOffsetSerializer() {
        super(RevisionOffsetComparator.INSTANCE);
    }

    static RevisionOffset deserialize(byte[] in) {
        return RevisionOffsetSerializer.deserialize(in, 0);
    }

    static RevisionOffset deserialize(byte[] in, int start) {
        if (in == null || in.length < 8 + start) {
            throw new SerializerCreationException("Cannot extract a RevisionOffset from a buffer with not enough bytes");
        }
        long revision = LongSerializer.deserialize(in, start);
        try {
            long[] offsets = LongArraySerializer.INSTANCE.fromBytes(in, 8 + start);
            RevisionOffset RevisionOffset2 = new RevisionOffset(revision, offsets);
            return RevisionOffset2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RevisionOffset fromBytes(byte[] in) {
        return RevisionOffsetSerializer.deserialize(in, 0);
    }

    @Override
    public RevisionOffset fromBytes(byte[] in, int start) {
        if (in == null || in.length < 8 + start) {
            throw new SerializerCreationException("Cannot extract a RevisionOffset from a buffer with not enough bytes");
        }
        return RevisionOffsetSerializer.deserialize(in, start);
    }

    @Override
    public byte[] serialize(RevisionOffset RevisionOffset2) {
        if (RevisionOffset2 == null) {
            throw new SerializerCreationException("The RevisionOffset instance should not be null ");
        }
        byte[] result = null;
        byte[] offsets = LongArraySerializer.INSTANCE.serialize(RevisionOffset2.getOffsets());
        result = new byte[8 + offsets.length];
        LongSerializer.serialize(result, 0, RevisionOffset2.getRevision());
        System.arraycopy(offsets, 0, result, 8, offsets.length);
        return result;
    }

    static byte[] serialize(byte[] buffer, int start, RevisionOffset RevisionOffset2) {
        LongSerializer.serialize(buffer, start, RevisionOffset2.getRevision());
        byte[] offsets = LongArraySerializer.INSTANCE.serialize(RevisionOffset2.getOffsets());
        System.arraycopy(offsets, 0, buffer, 8 + start, offsets.length);
        return buffer;
    }

    @Override
    public RevisionOffset deserialize(BufferHandler bufferHandler) throws IOException {
        byte[] revisionBytes = bufferHandler.read(8);
        long revision = LongSerializer.deserialize(revisionBytes);
        long[] offsets = LongArraySerializer.INSTANCE.deserialize(bufferHandler);
        return new RevisionOffset(revision, offsets);
    }

    @Override
    public RevisionOffset deserialize(ByteBuffer buffer) throws IOException {
        long revision = buffer.getLong();
        long[] offsets = LongArraySerializer.INSTANCE.deserialize(buffer);
        return new RevisionOffset(revision, offsets);
    }
}

