/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import java.util.Arrays;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.ConnectionFactoryManager;
import org.ldaptive.LdapException;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchResult;
import org.ldaptive.auth.AbstractSearchEntryResolver;
import org.ldaptive.auth.AuthenticationCriteria;

public class SearchEntryResolver
extends AbstractSearchEntryResolver
implements ConnectionFactoryManager {
    private ConnectionFactory factory;

    public SearchEntryResolver() {
    }

    @Deprecated
    public SearchEntryResolver(String ... attrs) {
        this.setReturnAttributes(attrs);
    }

    public SearchEntryResolver(ConnectionFactory cf) {
        this.setConnectionFactory(cf);
    }

    @Deprecated
    public SearchEntryResolver(ConnectionFactory cf, String ... attrs) {
        this.setConnectionFactory(cf);
        this.setReturnAttributes(attrs);
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        return this.factory;
    }

    @Override
    public void setConnectionFactory(ConnectionFactory cf) {
        this.factory = cf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchResult performLdapSearch(Connection conn, AuthenticationCriteria ac) throws LdapException {
        if (this.factory == null) {
            SearchOperation op = this.createSearchOperation(conn);
            return (SearchResult)op.execute(this.createSearchRequest(ac)).getResult();
        }
        Connection factoryConn = null;
        try {
            factoryConn = this.factory.getConnection();
            factoryConn.open();
            SearchOperation op = this.createSearchOperation(factoryConn);
            SearchResult searchResult = (SearchResult)op.execute(this.createSearchRequest(ac)).getResult();
            return searchResult;
        }
        finally {
            if (factoryConn != null) {
                factoryConn.close();
            }
        }
    }

    public String toString() {
        return String.format("[%s@%d::factory=%s, baseDn=%s, userFilter=%s, userFilterParameters=%s, allowMultipleEntries=%s, subtreeSearch=%s, derefAliases=%s, followReferrals=%s, searchEntryHandlers=%s]", new Object[]{this.getClass().getName(), this.hashCode(), this.factory, this.getBaseDn(), this.getUserFilter(), Arrays.toString(this.getUserFilterParameters()), this.getAllowMultipleEntries(), this.getSubtreeSearch(), this.getDerefAliases(), this.getFollowReferrals(), Arrays.toString(this.getSearchEntryHandlers())});
    }
}

