/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkAnonymousExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;

final class ReadAllQueryBuilder
extends EclipseLinkAnonymousExpressionVisitor {
    ReadAllQuery query;
    private final JPQLQueryContext queryContext;
    private SelectStatement selectStatement;

    ReadAllQueryBuilder(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    private void initializeReadAllQuery() {
        ReadAllQuery query = new ReadAllQuery();
        query.dontUseDistinct();
        this.query = query;
    }

    private void initializeReportQuery() {
        ReportQuery query = new ReportQuery();
        query.returnWithoutReportQueryResult();
        query.dontUseDistinct();
        this.query = query;
    }

    public void visit(CollectionExpression expression) {
        this.initializeReportQuery();
    }

    protected void visit(Expression expression) {
        this.initializeReportQuery();
    }

    public void visit(IdentificationVariable expression) {
        String variableName = expression.getVariableName();
        if (this.queryContext.isRangeIdentificationVariable(variableName)) {
            if (this.selectStatement.hasGroupByClause() || this.selectStatement.hasHavingClause() || variableName != this.queryContext.getFirstDeclaration().getVariableName()) {
                this.initializeReportQuery();
            } else {
                this.initializeReadAllQuery();
            }
        } else {
            this.initializeReportQuery();
        }
    }

    public void visit(NullExpression expression) {
        this.initializeReadAllQuery();
    }

    public void visit(ObjectExpression expression) {
        expression.getExpression().accept((ExpressionVisitor)this);
    }

    public void visit(ResultVariable expression) {
        expression.getSelectExpression().accept((ExpressionVisitor)this);
    }

    public void visit(SelectClause expression) {
        expression.getSelectExpression().accept((ExpressionVisitor)this);
    }

    public void visit(SelectStatement expression) {
        this.selectStatement = expression;
        expression.getSelectClause().accept((ExpressionVisitor)this);
    }
}

