/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.hdfs;

import java.io.File;
import java.util.concurrent.Callable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.EmptyResponse;
import org.apache.knox.gateway.shell.KnoxSession;
import org.apache.knox.gateway.shell.KnoxShellException;

public class Put {

    public static class Response
    extends EmptyResponse {
        Response(HttpResponse response) {
            super(response);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private String text;
        private String file;
        private String to;
        private boolean overwrite;
        private int permission = 755;
        private Integer blocksize;
        private Integer buffersize;
        private Short replication;

        Request(KnoxSession session) {
            super(session);
        }

        public Request text(String text) {
            this.text = text;
            return this;
        }

        public Request file(String file) {
            this.file = file;
            return this;
        }

        public Request to(String file) {
            this.to = file;
            return this;
        }

        public Request overwrite(boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public Request permission(int permission) {
            this.permission = permission;
            return this;
        }

        public Request blocksize(Integer blocksize) {
            this.blocksize = blocksize;
            return this;
        }

        public Request replication(Short replication) {
            this.replication = replication;
            return this;
        }

        public Request buffersize(Integer buffersize) {
            this.buffersize = buffersize;
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    URIBuilder uri = this.uri(new String[]{"/webhdfs/v1", to});
                    this.addQueryParam(uri, "op", "CREATE");
                    this.addQueryParam(uri, "overwrite", overwrite);
                    this.addQueryParam(uri, "permission", permission);
                    this.addQueryParam(uri, "blocksize", blocksize);
                    this.addQueryParam(uri, "replication", replication);
                    this.addQueryParam(uri, "buffersize", buffersize);
                    HttpPut nn = new HttpPut(uri.build());
                    CloseableHttpResponse r = this.execute((HttpRequest)nn);
                    if (r.getStatusLine().getStatusCode() != 307) {
                        throw new KnoxShellException(r.getStatusLine().toString());
                    }
                    EntityUtils.consumeQuietly((HttpEntity)r.getEntity());
                    Header[] h = r.getHeaders("Location");
                    if (h == null || h.length != 1) {
                        throw new KnoxShellException("Invalid Location header.");
                    }
                    String loc = h[0].getValue();
                    HttpPut dn = new HttpPut(loc);
                    StringEntity e = null;
                    if (text != null) {
                        e = new StringEntity(text);
                    } else if (file != null) {
                        e = new FileEntity(new File(file));
                    }
                    dn.setEntity((HttpEntity)e);
                    return new Response((HttpResponse)this.execute((HttpRequest)dn));
                }
            };
        }
    }
}

