/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart.bean;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfoTyped;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.ClassUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Request;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.MethodInfoUtils;
import org.apache.juneau.httppart.bean.RequestBeanPropertyMeta;

public class RequestBeanMeta {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    private final ClassMeta<?> cm;
    private final Map<String, RequestBeanPropertyMeta> properties;
    private final HttpPartSerializer serializer;
    private final HttpPartParser parser;

    public static RequestBeanMeta create(Class<?> c, AnnotationWorkList annotations) {
        ClassInfoTyped<?> ci = ReflectionUtils.info(c);
        if (!ci.hasAnnotation(Request.class)) {
            return null;
        }
        return new Builder(annotations).apply(c).build();
    }

    public static RequestBeanMeta create(ParameterInfo mpi, AnnotationWorkList annotations) {
        if (!AP.has(Request.class, mpi, new AnnotationTraversal[0])) {
            return null;
        }
        return new Builder(annotations).apply(mpi).build();
    }

    RequestBeanMeta(Builder b) {
        this.cm = b.cm;
        this.serializer = b.serializer.orElse(null);
        this.parser = b.parser.orElse(null);
        LinkedHashMap pm = CollectionUtils.map();
        b.properties.forEach((k, v) -> pm.put(k, v.build(this.serializer, this.parser)));
        this.properties = CollectionUtils.u(pm);
    }

    public ClassMeta<?> getClassMeta() {
        return this.cm;
    }

    public Collection<RequestBeanPropertyMeta> getProperties() {
        return this.properties.values();
    }

    public RequestBeanPropertyMeta getProperty(String name) {
        return this.properties.get(name);
    }

    static class Builder {
        ClassMeta<?> cm;
        AnnotationWorkList annotations;
        BeanCreator<HttpPartSerializer> serializer = BeanCreator.of(HttpPartSerializer.class);
        BeanCreator<HttpPartParser> parser = BeanCreator.of(HttpPartParser.class);
        Map<String, RequestBeanPropertyMeta.Builder> properties = CollectionUtils.map();

        Builder(AnnotationWorkList annotations) {
            this.annotations = annotations;
        }

        Builder apply(Class<?> c) {
            this.cm = BeanContext.DEFAULT.getClassMeta(c);
            AnnotationProvider ap = this.cm.getBeanContext().getAnnotationProvider();
            this.apply((Request)ap.find(Request.class, this.cm, new AnnotationTraversal[0]).stream().findFirst().map(x -> (Request)x.inner()).orElse(null));
            this.cm.getPublicMethods().stream().forEach(x -> {
                String n = x.getSimpleName();
                if (x.hasAnnotation(Header.class)) {
                    MethodInfoUtils.assertNoArgs(x, Header.class);
                    MethodInfoUtils.assertReturnNotVoid(x, Header.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.HEADER, Header.class, x));
                } else if (x.hasAnnotation(Query.class)) {
                    MethodInfoUtils.assertNoArgs(x, Query.class);
                    MethodInfoUtils.assertReturnNotVoid(x, Query.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.QUERY, Query.class, x));
                } else if (x.hasAnnotation(FormData.class)) {
                    MethodInfoUtils.assertNoArgs(x, FormData.class);
                    MethodInfoUtils.assertReturnNotVoid(x, FormData.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.FORMDATA, FormData.class, x));
                } else if (x.hasAnnotation(Path.class)) {
                    MethodInfoUtils.assertNoArgs(x, Path.class);
                    MethodInfoUtils.assertReturnNotVoid(x, Path.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.PATH, Path.class, x));
                } else if (x.hasAnnotation(Content.class)) {
                    MethodInfoUtils.assertNoArgs(x, Content.class);
                    MethodInfoUtils.assertReturnNotVoid(x, Content.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.BODY, Content.class, x));
                }
            });
            return this;
        }

        Builder apply(ParameterInfo mpi) {
            return this.apply(mpi.getParameterType().inner()).apply((Request)AP.find(Request.class, mpi, new AnnotationTraversal[0]).stream().findFirst().map(AnnotationInfo::inner).orElse(null));
        }

        Builder apply(Request a) {
            if (Utils.nn(a)) {
                if (ClassUtils.isNotVoid(a.serializer())) {
                    this.serializer.type(a.serializer());
                }
                if (ClassUtils.isNotVoid(a.parser())) {
                    this.parser.type(a.parser());
                }
            }
            return this;
        }

        RequestBeanMeta build() {
            return new RequestBeanMeta(this);
        }
    }
}

