/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.function;

import org.apache.juneau.commons.function.Consumer4;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;

@FunctionalInterface
public interface ThrowingConsumer4<A, B, C, D>
extends Consumer4<A, B, C, D> {
    @Override
    default public void apply(A a, B b, C c, D d) {
        try {
            this.acceptThrows(a, b, c, d);
        }
        catch (Exception e) {
            throw ThrowableUtils.toRex(e);
        }
    }

    @Override
    default public ThrowingConsumer4<A, B, C, D> andThen(ThrowingConsumer4<? super A, ? super B, ? super C, ? super D> after) {
        AssertionUtils.assertArgNotNull("after", after);
        return (a, b, c, d) -> {
            this.acceptThrows(a, b, c, d);
            after.acceptThrows(a, b, c, d);
        };
    }

    public void acceptThrows(A var1, B var2, C var3, D var4) throws Exception;
}

