/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.processor;

import java.io.IOException;
import org.apache.http.Header;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.response.BasicHttpException;
import org.apache.juneau.http.response.NotAcceptable;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.processor.ResponseProcessor;
import org.apache.juneau.rest.util.FinishablePrintWriter;

public final class PlainTextPojoProcessor
implements ResponseProcessor {
    @Override
    public int process(RestOpSession opSession) throws IOException, NotAcceptable, BasicHttpException {
        RestRequest req = opSession.getRequest();
        RestResponse res = opSession.getResponse();
        String accept = req.getHeaderParam("Accept").orElse("*/*");
        if (res.getSerializerMatch().isPresent() || !StringUtils.isEmpty(accept) && !accept.startsWith("text/plain") && !accept.contains("*/*")) {
            return 0;
        }
        Object o = res.getContent(Object.class);
        if (StringUtils.isEmpty(res.getContentType())) {
            res.setHeader((Header)ContentType.TEXT_PLAIN);
        }
        FinishablePrintWriter w = res.getNegotiatedWriter();
        if (o == null) {
            w.append("null");
        } else {
            w.append(req.getBeanSession().getClassMetaForObject(o).toString(o));
        }
        w.flush();
        w.finish();
        return 1;
    }
}

