/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.jsonschema;

import java.io.Reader;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.dto.jsonschema.JsonSchema;
import org.apache.juneau.json.JsonParser;

public abstract class JsonSchemaMap
extends ConcurrentHashMap<URI, JsonSchema> {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JsonSchema get(Object uri) {
        URI u = StringUtils.toURI(uri);
        JsonSchema s = (JsonSchema)super.get(u);
        if (s != null) {
            return s;
        }
        JsonSchemaMap jsonSchemaMap = this;
        synchronized (jsonSchemaMap) {
            s = this.load(u);
            if (s != null) {
                s.setSchemaMap(this);
                this.put(u, s);
            }
            return s;
        }
    }

    public JsonSchemaMap add(JsonSchema ... schemas) {
        for (JsonSchema schema : schemas) {
            if (schema.getId() == null) {
                throw new IllegalArgumentException("Schema with no ID passed to JsonSchemaMap.add(Schema...)");
            }
            this.put(schema.getId(), schema);
            schema.setSchemaMap(this);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonSchema load(URI uri) {
        try (Reader r = this.getReader(uri);){
            if (r == null) {
                JsonSchema jsonSchema2 = null;
                return jsonSchema2;
            }
            JsonSchema jsonSchema = JsonParser.DEFAULT.parse((Object)r, JsonSchema.class);
            return jsonSchema;
        }
        catch (Exception e) {
            throw ThrowableUtils.asRuntimeException(e);
        }
    }

    public Reader getReader(URI uri) {
        return null;
    }
}

