/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock;

import java.util.Collections;
import java.util.Map;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.StateMachineState;
import org.apache.juneau.rest.util.UrlPath;
import org.apache.juneau.rest.util.UrlPathMatcher;

class MockPathResolver {
    private String uri;
    private String target;
    private String contextPath;
    private String servletPath;
    private String remainder;
    private String error;

    public MockPathResolver(String target, String contextPath, String servletPath, String pathToResolve, Map<String, Object> pathVars) {
        try {
            this.init(target, contextPath, servletPath, pathToResolve, pathVars);
        }
        catch (Exception e) {
            this.error = e.getLocalizedMessage();
        }
    }

    private void init(String target, String contextPath, String servletPath, String pathToResolve, Map<String, Object> pathVars) {
        UrlPathMatcher p;
        UrlPathMatcher p2;
        if ((target = StringUtils.trimTrailingSlashes((String)StringUtils.emptyIfNull((String)target))).isEmpty()) {
            target = "http://localhost";
        }
        contextPath = MockPathResolver.fixSegment(contextPath, pathVars);
        servletPath = MockPathResolver.fixSegment(servletPath, pathVars);
        if (!(pathToResolve = StringUtils.emptyIfNull((String)pathToResolve)).startsWith("http://") && !pathToResolve.startsWith("https://")) {
            pathToResolve = MockPathResolver.fixSegment(pathToResolve, Collections.emptyMap());
            this.uri = target + contextPath + servletPath + pathToResolve;
            this.target = target;
            this.contextPath = contextPath;
            this.servletPath = servletPath;
            this.remainder = pathToResolve;
            return;
        }
        this.uri = pathToResolve;
        StateMachineState state = StateMachineState.S03;
        int cpSegments = StringUtils.countChars((String)contextPath, (char)'/');
        int spSegments = StringUtils.countChars((String)servletPath, (char)'/');
        this.contextPath = "";
        this.servletPath = "";
        this.remainder = "";
        int mark = 0;
        for (int i = this.uri.indexOf("://") + 3; i < this.uri.length(); ++i) {
            char c = this.uri.charAt(i);
            if (state == StateMachineState.S03) {
                if (c == '/') break;
                state = StateMachineState.S04;
                continue;
            }
            if (state == StateMachineState.S04) {
                if (c != '/') continue;
                this.target = this.uri.substring(0, i);
                state = StateMachineState.S05;
                if (contextPath.isEmpty()) {
                    state = StateMachineState.S06;
                    if (servletPath.isEmpty()) {
                        state = StateMachineState.S07;
                    }
                }
                mark = i;
                continue;
            }
            if (state == StateMachineState.S05) {
                if (c != '/' || --cpSegments != 0) continue;
                this.contextPath = this.uri.substring(mark, i);
                mark = i;
                state = StateMachineState.S06;
                if (!servletPath.isEmpty()) continue;
                state = StateMachineState.S07;
                continue;
            }
            if (state != StateMachineState.S06 || c != '/' || --spSegments != 0) continue;
            this.servletPath = this.uri.substring(mark, i);
            mark = i;
            state = StateMachineState.S07;
        }
        if (state == StateMachineState.S04) {
            this.target = this.uri;
        } else if (state == StateMachineState.S05) {
            this.contextPath = this.uri.substring(mark);
        } else if (state == StateMachineState.S06) {
            this.servletPath = this.uri.substring(mark);
        } else if (state == StateMachineState.S07) {
            this.remainder = this.uri.substring(mark);
        } else {
            throw new BasicRuntimeException("Invalid URI pattern encountered:  {0}", new Object[]{this.uri});
        }
        if (!contextPath.isEmpty() && (p2 = UrlPathMatcher.of((String)contextPath)).match(UrlPath.of((String)this.contextPath)) == null) {
            throw new BasicRuntimeException("Context path [{0}] not found in URI:  {1}", new Object[]{contextPath, this.uri});
        }
        if (!servletPath.isEmpty() && (p = UrlPathMatcher.of((String)servletPath)).match(UrlPath.of((String)this.servletPath)) == null) {
            throw new BasicRuntimeException("Servlet path [{0}] not found in URI:  {1}", new Object[]{servletPath, this.uri});
        }
    }

    private static String fixSegment(String s, Map<String, Object> pathVars) {
        if (((String)(s = StringUtils.replaceVars((String)StringUtils.emptyIfNull((String)s), pathVars))).isEmpty() || ((String)s).equals("/")) {
            return "";
        }
        if (((String)(s = StringUtils.trimTrailingSlashes((String)s))).charAt(0) != '/') {
            s = "/" + (String)s;
        }
        return s;
    }

    public String getURI() {
        return this.uri;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getRemainder() {
        return this.remainder;
    }

    public String getTarget() {
        return this.target;
    }

    public String getError() {
        return this.error;
    }

    public String toString() {
        return JsonMap.create().append("uri", (Object)this.uri).append("contextPath", (Object)this.contextPath).append("servletPath", (Object)this.servletPath).append("remainder", (Object)this.remainder).append("target", (Object)this.target).append("error", (Object)this.error).toString();
    }
}

