/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client.remote;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.HttpHeaders;
import org.apache.juneau.http.header.HeaderList;
import org.apache.juneau.http.remote.Remote;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.rest.client.remote.RemoteOperationMeta;
import org.apache.juneau.svl.VarResolver;

public class RemoteMeta {
    private final Map<Method, RemoteOperationMeta> operations;
    private final HeaderList headers;

    public RemoteMeta(Class<?> c) {
        String path = "";
        ClassInfo ci = ClassInfo.of(c);
        List remotes = ci.getAnnotations(Remote.class);
        String versionHeader = "Client-Version";
        String clientVersion = null;
        HeaderList headers = HeaderList.create().resolving();
        for (Remote r : remotes) {
            if (StringUtils.isNotEmpty((String)r.path())) {
                path = StringUtils.trimSlashes((String)RemoteMeta.resolve(r.path()));
            }
            for (String h : r.headers()) {
                headers.append((Header)HttpHeaders.stringHeader((String)RemoteMeta.resolve(h)));
            }
            if (StringUtils.isNotEmpty((String)r.version())) {
                clientVersion = RemoteMeta.resolve(r.version());
            }
            if (StringUtils.isNotEmpty((String)r.versionHeader())) {
                versionHeader = RemoteMeta.resolve(r.versionHeader());
            }
            if (!ClassUtils.isNotVoid((Class)r.headerList())) continue;
            try {
                headers.append(((HeaderList)r.headerList().getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getAll());
            }
            catch (Exception e) {
                throw new BasicRuntimeException((Throwable)e, "Could not instantiate HeaderSupplier class", new Object[0]);
            }
        }
        if (clientVersion != null) {
            headers.append((Header)HttpHeaders.stringHeader((String)versionHeader, clientVersion));
        }
        LinkedHashMap operations = CollectionUtils.map();
        String path2 = path;
        ci.forEachPublicMethod(x -> true, x -> operations.put(x.inner(), new RemoteOperationMeta(path2, x.inner(), "GET")));
        this.operations = CollectionUtils.unmodifiable((Map)operations);
        this.headers = headers;
    }

    public RemoteOperationMeta getOperationMeta(Method m) {
        return this.operations.get(m);
    }

    public HeaderList getHeaders() {
        return this.headers;
    }

    private static String resolve(String s) {
        return VarResolver.DEFAULT.resolve(s);
    }
}

