/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.transaction.txn;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.dboe.transaction.txn.TxnIdGenerator;
import org.apache.jena.dboe.transaction.txn.TxnIdSimple;
import org.apache.jena.dboe.transaction.txn.TxnIdUuid;

public class TxnIdFactory {
    public static final TxnIdGenerator txnIdGenSimple = () -> TxnIdSimple.create();
    public static final TxnIdGenerator txnIdGenUuid = () -> TxnIdUuid.create();

    public static TxnId create() {
        return TxnIdFactory.createSimple();
    }

    public static TxnId createSimple() {
        return txnIdGenSimple.generate();
    }

    public static TxnId createUuid() {
        return txnIdGenUuid.generate();
    }

    public static TxnId create(byte[] bytes) {
        switch (bytes.length) {
            case 8: {
                return TxnIdSimple.create(bytes);
            }
            case 16: {
                return TxnIdUuid.create(bytes);
            }
        }
        throw new NotImplementedException("Unrecognized bytes length: " + bytes.length);
    }
}

