/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.mail.MessagingException;
import java.util.Collection;
import org.apache.james.core.MailAddress;
import org.apache.james.droplists.api.DropList;
import org.apache.james.droplists.api.OwnerScope;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import reactor.core.publisher.Mono;
import reactor.function.TupleUtils;

public class IsInDropList
extends GenericMatcher {
    private final DropList dropList;

    @Inject
    public IsInDropList(DropList dropList) {
        this.dropList = dropList;
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        return (Collection)mail.getRecipients().stream().filter(recipient -> this.isRecipientAllowed(mail, (MailAddress)recipient)).collect(ImmutableList.toImmutableList());
    }

    private Boolean isRecipientAllowed(Mail mail, MailAddress recipient) {
        MailAddress sender = mail.getMaybeSender().get();
        Mono globalStatusQuery = this.dropList.query(OwnerScope.GLOBAL, recipient.asString(), sender);
        Mono domainStatusQuery = this.dropList.query(OwnerScope.DOMAIN, recipient.getDomain().asString(), sender);
        Mono userStatusQuery = this.dropList.query(OwnerScope.USER, recipient.asString(), sender);
        return (Boolean)Mono.zip((Mono)globalStatusQuery, (Mono)domainStatusQuery, (Mono)userStatusQuery).map(TupleUtils.function(IsInDropList::isAllowed)).block();
    }

    private static boolean isAllowed(DropList.Status globalStatus, DropList.Status domainStatus, DropList.Status userStatus) {
        return globalStatus == DropList.Status.ALLOWED && domainStatus == DropList.Status.ALLOWED && userStatus == DropList.Status.ALLOWED;
    }
}

