/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;
import org.apache.derby.shared.common.error.StandardException;

public class SpecificAuthenticationServiceImpl
extends AuthenticationServiceBase {
    private String specificAuthenticationScheme;

    @Override
    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        if (PropertyUtil.nativeAuthenticationEnabled(properties)) {
            return false;
        }
        this.specificAuthenticationScheme = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return this.specificAuthenticationScheme != null && this.specificAuthenticationScheme.length() != 0 && !StringUtil.SQLEqualsIgnoreCase(this.specificAuthenticationScheme, "BUILTIN") && !this.specificAuthenticationScheme.equalsIgnoreCase("LDAP");
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        ReflectiveOperationException reflectiveOperationException;
        super.boot(bl, properties);
        try {
            Class<?> clazz = Class.forName(this.specificAuthenticationScheme);
            if (!UserAuthenticator.class.isAssignableFrom(clazz)) {
                throw StandardException.newException((String)"XBM0L.D", (Object[])new Object[]{this.specificAuthenticationScheme, "org.apache.derby.authentication.UserAuthenticator"});
            }
            UserAuthenticator userAuthenticator = (UserAuthenticator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.setAuthenticationService(userAuthenticator);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            reflectiveOperationException = noSuchMethodException;
        }
        catch (InvocationTargetException invocationTargetException) {
            reflectiveOperationException = invocationTargetException;
        }
        String string = reflectiveOperationException.getClass().getName() + ": " + reflectiveOperationException.getMessage();
        throw StandardException.newException((String)"XBM0M.D", (Object[])new Object[]{this.specificAuthenticationScheme, string});
    }
}

