/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBinary;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.shared.common.error.StandardException;

public class SQLBit
extends SQLBinary {
    @Override
    public Object getObject() throws StandardException {
        return this.getBytes();
    }

    @Override
    public String getTypeName() {
        return "CHAR () FOR BIT DATA";
    }

    @Override
    int getMaxMemoryUsage() {
        return 254;
    }

    @Override
    public int getTypeFormatId() {
        return 87;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLBit();
    }

    @Override
    public final void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        this.setValue(resultSet.getBytes(n));
    }

    @Override
    public int typePrecedence() {
        return 140;
    }

    @Override
    final void setObject(Object object) throws StandardException {
        this.setValue((byte[])object);
    }

    public SQLBit() {
    }

    public SQLBit(byte[] byArray) {
        this.dataValue = byArray;
    }

    @Override
    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n = dataTypeDescriptor.getMaximumWidth();
        this.setValue(dataValueDescriptor.getBytes());
        this.setWidth(n, 0, true);
    }

    @Override
    public void setWidth(int n, int n2, boolean bl) throws StandardException {
        if (this.getValue() == null) {
            return;
        }
        int n3 = this.dataValue.length;
        if (n3 < n) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.dataValue, 0, byArray, 0, this.dataValue.length);
            Arrays.fill(byArray, this.dataValue.length, byArray.length, (byte)32);
            this.dataValue = byArray;
        } else if (n3 > n) {
            if (bl) {
                for (int i = n; i < this.dataValue.length; ++i) {
                    if (this.dataValue[i] == 32) continue;
                    throw StandardException.newException((String)"22001", (Object[])new Object[]{this.getTypeName(), StringUtil.formatForPrint(this.toString()), String.valueOf(n)});
                }
            }
            this.truncate(n3, n, !bl);
        }
    }
}

