/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util.git;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitUtils {
    static final Pattern fullRevisionPattern = Pattern.compile("[0-9A-Fa-f]+(([Mm]+)?)");
    static final Pattern revisionPattern = Pattern.compile("[0-9A-Fa-f]+");

    public static int convertGitInfoToPCEnhancerVersion(String gitinfo) {
        if (gitinfo == null || !fullRevisionPattern.matcher(gitinfo).matches()) {
            return -1;
        }
        Matcher matcher = revisionPattern.matcher(gitinfo);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(), 16);
        }
        return -1;
    }
}

