/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.webadmin.service.ExpireMailboxService;
import org.apache.james.webadmin.service.ExpireMailboxTask;

public class ExpireMailboxAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final Instant timestamp;
    private final String type;
    private final ExpireMailboxService.RunningOptions runningOptions;
    private final long mailboxesExpired;
    private final long mailboxesFailed;
    private final long mailboxesProcessed;
    private final long messagesDeleted;

    public static AdditionalInformationDTOModule<ExpireMailboxTask.AdditionalInformation, ExpireMailboxAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(ExpireMailboxTask.AdditionalInformation.class).convertToDTO(ExpireMailboxAdditionalInformationDTO.class).toDomainObjectConverter(ExpireMailboxAdditionalInformationDTO::toDomainObject).toDTOConverter(ExpireMailboxAdditionalInformationDTO::toDto).typeName(ExpireMailboxTask.TASK_TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    private static ExpireMailboxTask.AdditionalInformation toDomainObject(ExpireMailboxAdditionalInformationDTO dto) {
        return new ExpireMailboxTask.AdditionalInformation(dto.getTimestamp(), dto.getRunningOptions(), dto.getMailboxesExpired(), dto.getMailboxesFailed(), dto.getMailboxesProcessed(), dto.getMessagesDeleted());
    }

    private static ExpireMailboxAdditionalInformationDTO toDto(ExpireMailboxTask.AdditionalInformation details, String type) {
        return new ExpireMailboxAdditionalInformationDTO(details.timestamp(), type, details.getRunningOptions(), details.getMailboxesExpired(), details.getMailboxesFailed(), details.getMailboxesProcessed(), details.getMessagesDeleted());
    }

    @JsonCreator
    public ExpireMailboxAdditionalInformationDTO(@JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="type") String type, @JsonProperty(value="runningOptions") ExpireMailboxService.RunningOptions runningOptions, @JsonProperty(value="mailboxesExpired") long mailboxesExpired, @JsonProperty(value="mailboxesFailed") long mailboxesFailed, @JsonProperty(value="mailboxesProcessed") long mailboxesProcessed, @JsonProperty(value="messagesDeleted") long messagesDeleted) {
        this.timestamp = timestamp;
        this.type = type;
        this.runningOptions = runningOptions;
        this.mailboxesExpired = mailboxesExpired;
        this.mailboxesFailed = mailboxesFailed;
        this.mailboxesProcessed = mailboxesProcessed;
        this.messagesDeleted = messagesDeleted;
    }

    public ExpireMailboxService.RunningOptions getRunningOptions() {
        return this.runningOptions;
    }

    public long getMailboxesExpired() {
        return this.mailboxesExpired;
    }

    public long getMailboxesFailed() {
        return this.mailboxesFailed;
    }

    public long getMailboxesProcessed() {
        return this.mailboxesProcessed;
    }

    public long getMessagesDeleted() {
        return this.messagesDeleted;
    }

    public String getType() {
        return this.type;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }
}

