/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogFieldSyntax;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class StringLogFieldSyntax
extends LogFieldSyntax<CharSequence> {
    @NotNull
    public static final String SYNTAX_NAME = "string";

    public StringLogFieldSyntax(int maxStringLengthCharacters) {
        super(maxStringLengthCharacters);
    }

    @Override
    @NotNull
    public String getSyntaxName() {
        return SYNTAX_NAME;
    }

    @Override
    public void valueToSanitizedString(@NotNull CharSequence value, @NotNull ByteStringBuffer buffer) {
        this.sanitize(value.toString(), buffer);
    }

    @Override
    public void logSanitizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull CharSequence fieldValue, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.valueToSanitizedString(fieldValue, buffer);
        buffer.append('\"');
    }

    @Override
    public void logSanitizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull CharSequence fieldValue, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.valueToSanitizedString(fieldValue));
    }

    @Override
    public void logSanitizedValueToJSONFormattedLog(@NotNull CharSequence value, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.valueToSanitizedString(value));
    }

    @Override
    @NotNull
    public String parseValue(@NotNull String valueString) {
        return valueString;
    }

    @Override
    public boolean completelyRedactedValueConformsToSyntax() {
        return true;
    }

    @Override
    public void logCompletelyRedactedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        buffer.append("{REDACTED}");
        buffer.append('\"');
    }

    @Override
    public void logCompletelyRedactedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, "{REDACTED}");
    }

    @Override
    public void logCompletelyRedactedValueToJSONFormattedLog(@NotNull JSONBuffer buffer) {
        buffer.appendString("{REDACTED}");
    }

    @Override
    public boolean supportsRedactedComponents() {
        return false;
    }

    @Override
    public boolean valueWithRedactedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void logRedactedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull CharSequence fieldValue, @NotNull ByteStringBuffer buffer) {
        this.logCompletelyRedactedFieldToTextFormattedLog(fieldName, buffer);
    }

    @Override
    public void logRedactedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull CharSequence fieldValue, @NotNull JSONBuffer buffer) {
        this.logCompletelyRedactedFieldToJSONFormattedLog(fieldName, buffer);
    }

    @Override
    public void logRedactedComponentsValueToJSONFormattedLog(@NotNull CharSequence value, @NotNull JSONBuffer buffer) {
        this.logCompletelyRedactedValueToJSONFormattedLog(buffer);
    }

    @Override
    public boolean completelyTokenizedValueConformsToSyntax() {
        return true;
    }

    @Override
    public void tokenizeEntireValue(@NotNull CharSequence value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        this.tokenize(value.toString(), pepper, buffer);
    }

    @Override
    public void logCompletelyTokenizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull CharSequence fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        this.tokenizeEntireValue(fieldValue, pepper, buffer);
        buffer.append('\"');
    }

    @Override
    public void logCompletelyTokenizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull CharSequence fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(fieldName, this.tokenizeEntireValue(fieldValue, pepper));
    }

    @Override
    public void logCompletelyTokenizedValueToJSONFormattedLog(@NotNull CharSequence value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendString(this.tokenizeEntireValue(value, pepper));
    }

    @Override
    public boolean supportsTokenizedComponents() {
        return false;
    }

    @Override
    public boolean valueWithTokenizedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void logTokenizedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull CharSequence fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        this.logCompletelyTokenizedFieldToTextFormattedLog(fieldName, fieldValue, pepper, buffer);
    }

    @Override
    public void logTokenizedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull CharSequence fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        this.logCompletelyTokenizedFieldToJSONFormattedLog(fieldName, fieldValue, pepper, buffer);
    }

    @Override
    public void logTokenizedComponentsValueToJSONFormattedLog(@NotNull CharSequence value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        this.logCompletelyTokenizedValueToJSONFormattedLog(value, pepper, buffer);
    }
}

