/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.shared.common.util.ArrayUtil;

public class ColumnInfo
implements Formatable {
    int action;
    String name;
    DataTypeDescriptor dataType;
    DefaultInfo defaultInfo;
    ProviderInfo[] providers;
    DataValueDescriptor defaultValue;
    UUID newDefaultUUID;
    UUID oldDefaultUUID;
    long autoincStart;
    long autoincInc;
    boolean autoincCycle;
    long autoinc_create_or_modify_Start_Increment = -1L;
    public static final int CREATE = 0;
    public static final int DROP = 1;
    public static final int MODIFY_COLUMN_TYPE = 2;
    public static final int MODIFY_COLUMN_CONSTRAINT = 3;
    public static final int MODIFY_COLUMN_CONSTRAINT_NOT_NULL = 4;
    public static final int MODIFY_COLUMN_DEFAULT_RESTART = 5;
    public static final int MODIFY_COLUMN_DEFAULT_INCREMENT = 6;
    public static final int MODIFY_COLUMN_DEFAULT_VALUE = 7;
    public static final int MODIFY_COLUMN_GENERATED_ALWAYS = 8;
    public static final int MODIFY_COLUMN_GENERATED_BY_DEFAULT = 9;
    public static final int MODIFY_COLUMN_DEFAULT_CYCLE = 10;

    public ColumnInfo() {
    }

    public ColumnInfo(String string, DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor, DefaultInfo defaultInfo, ProviderInfo[] providerInfoArray, UUID uUID, UUID uUID2, int n, long l, long l2, boolean bl, long l3) {
        this.name = string;
        this.dataType = dataTypeDescriptor;
        this.defaultValue = dataValueDescriptor;
        this.defaultInfo = defaultInfo;
        this.providers = (ProviderInfo[])ArrayUtil.copy((Object[])providerInfoArray);
        this.newDefaultUUID = uUID;
        this.oldDefaultUUID = uUID2;
        this.action = n;
        this.autoincStart = l;
        this.autoincInc = l2;
        this.autoincCycle = bl;
        this.autoinc_create_or_modify_Start_Increment = l3;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        FormatableHashtable formatableHashtable = (FormatableHashtable)objectInput.readObject();
        this.name = (String)formatableHashtable.get("name");
        this.dataType = (DataTypeDescriptor)formatableHashtable.get("dataType");
        this.defaultValue = (DataValueDescriptor)formatableHashtable.get("defaultValue");
        this.defaultInfo = (DefaultInfo)formatableHashtable.get("defaultInfo");
        this.newDefaultUUID = (UUID)formatableHashtable.get("newDefaultUUID");
        this.oldDefaultUUID = (UUID)formatableHashtable.get("oldDefaultUUID");
        this.action = formatableHashtable.getInt("action");
        if (formatableHashtable.get("autoincStart") != null) {
            this.autoincStart = formatableHashtable.getLong("autoincStart");
            this.autoincInc = formatableHashtable.getLong("autoincInc");
        } else {
            this.autoincStart = 0L;
            this.autoincInc = 0L;
        }
        FormatableArrayHolder formatableArrayHolder = (FormatableArrayHolder)formatableHashtable.get("providers");
        if (formatableArrayHolder != null) {
            this.providers = (ProviderInfo[])formatableArrayHolder.getArray(ProviderInfo[].class);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FormatableHashtable formatableHashtable = new FormatableHashtable();
        formatableHashtable.put("name", this.name);
        formatableHashtable.put("dataType", this.dataType);
        formatableHashtable.put("defaultValue", this.defaultValue);
        formatableHashtable.put("defaultInfo", this.defaultInfo);
        formatableHashtable.put("newDefaultUUID", this.newDefaultUUID);
        formatableHashtable.put("oldDefaultUUID", this.oldDefaultUUID);
        formatableHashtable.putInt("action", this.action);
        if (this.autoincInc != 0L) {
            formatableHashtable.putLong("autoincStart", this.autoincStart);
            formatableHashtable.putLong("autoincInc", this.autoincInc);
        }
        if (this.providers != null) {
            FormatableArrayHolder formatableArrayHolder = new FormatableArrayHolder(this.providers);
            formatableHashtable.put("providers", formatableArrayHolder);
        }
        objectOutput.writeObject(formatableHashtable);
    }

    @Override
    public int getTypeFormatId() {
        return 358;
    }

    public DataTypeDescriptor getDataType() {
        return this.dataType;
    }

    public String toString() {
        return "";
    }
}

