/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp;

import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.james.protocols.api.OidcSASLConfiguration;
import org.apache.james.protocols.api.ProtocolConfiguration;

public interface SMTPConfiguration
extends ProtocolConfiguration {
    public long getMaxMessageSize();

    public boolean isRelayingAllowed(String var1);

    public boolean isAuthAnnounced(String var1, boolean var2);

    public SenderVerificationMode verifyIdentity();

    public boolean useHeloEhloEnforcement();

    public boolean useAddressBracketsEnforcement();

    public boolean isPlainAuthEnabled();

    public Optional<OidcSASLConfiguration> saslConfiguration();

    default public Set<String> disabledFeatures() {
        return ImmutableSet.of();
    }

    public static enum SenderVerificationMode {
        STRICT,
        RELAXED,
        DISABLED;


        public static SenderVerificationMode parse(String value) {
            return switch (value.toLowerCase(Locale.US).trim()) {
                case "true", "strict" -> STRICT;
                case "false", "disabled" -> DISABLED;
                case "relaxed" -> RELAXED;
                default -> throw new RuntimeException("SenderVerificationMode: unsupported value '" + value + "'");
            };
        }
    }
}

