/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.instrumentation;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.openjpa.datacache.AbstractQueryCache;
import org.apache.openjpa.datacache.QueryCache;
import org.apache.openjpa.datacache.QueryKey;
import org.apache.openjpa.instrumentation.QueryCacheInstrument;
import org.apache.openjpa.kernel.QueryStatistics;
import org.apache.openjpa.lib.instrumentation.AbstractInstrument;
import org.apache.openjpa.lib.instrumentation.InstrumentationLevel;

public abstract class AbstractQueryCacheInstrument
extends AbstractInstrument
implements QueryCacheInstrument {
    public static final long NO_STATS = -1L;
    private QueryCache _qc;
    private String _configId = null;
    private String _configRef = null;

    public void setQueryCache(QueryCache qc) {
        this._qc = qc;
    }

    public void setConfigId(String cid) {
        this._configId = cid;
    }

    public void setContextRef(String cref) {
        this._configRef = cref;
    }

    public String getConfigId() {
        return this._configId;
    }

    public String getContextRef() {
        return this._configRef;
    }

    public void setPreparedQueryCache(QueryCache qc) {
        this._qc = qc;
    }

    private QueryStatistics<QueryKey> getStatistics() {
        if (this._qc == null) {
            return null;
        }
        return this._qc.getStatistics();
    }

    @Override
    public long getExecutionCount() {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            return stats.getExecutionCount();
        }
        return -1L;
    }

    @Override
    public long getExecutionCount(String queryKey) {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            QueryKey qk = this.findKey(queryKey);
            return stats.getExecutionCount(qk);
        }
        return -1L;
    }

    @Override
    public long getTotalExecutionCount() {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            return stats.getTotalExecutionCount();
        }
        return -1L;
    }

    @Override
    public long getTotalExecutionCount(String queryKey) {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            QueryKey qk = this.findKey(queryKey);
            return stats.getTotalExecutionCount(qk);
        }
        return -1L;
    }

    @Override
    public long getHitCount() {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            return stats.getHitCount();
        }
        return -1L;
    }

    @Override
    public long getHitCount(String queryKey) {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            QueryKey qk = this.findKey(queryKey);
            return stats.getHitCount(qk);
        }
        return -1L;
    }

    @Override
    public long getTotalHitCount() {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            return stats.getTotalHitCount();
        }
        return -1L;
    }

    @Override
    public long getTotalHitCount(String queryKey) {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            QueryKey qk = this.findKey(queryKey);
            return stats.getTotalHitCount(qk);
        }
        return -1L;
    }

    @Override
    public void reset() {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            stats.reset();
        }
    }

    @Override
    public Date sinceDate() {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            return stats.since();
        }
        return null;
    }

    @Override
    public Date startDate() {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            return stats.start();
        }
        return null;
    }

    @Override
    public long getEvictionCount() {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            return stats.getEvictionCount();
        }
        return -1L;
    }

    @Override
    public long getTotalEvictionCount() {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            return stats.getTotalEvictionCount();
        }
        return -1L;
    }

    @Override
    public Set<String> queryKeys() {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        if (stats != null) {
            HashSet<String> keys = new HashSet<String>();
            for (QueryKey qk : stats.keys()) {
                keys.add(qk.toString());
            }
            return keys;
        }
        return null;
    }

    private QueryKey findKey(String key) {
        QueryStatistics<QueryKey> stats = this.getStatistics();
        for (QueryKey qk : stats.keys()) {
            if (!qk.toString().equals(key)) continue;
            return qk;
        }
        return null;
    }

    @Override
    public long count() {
        if (this._qc == null) {
            return -1L;
        }
        if (this._qc instanceof AbstractQueryCache) {
            AbstractQueryCache aqc = (AbstractQueryCache)this._qc;
            return aqc.count();
        }
        return -1L;
    }

    @Override
    public InstrumentationLevel getLevel() {
        return InstrumentationLevel.FACTORY;
    }
}

