/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventWithState;
import org.apache.james.eventsourcing.eventstore.History;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.ConfigurationChanged;

class ConfigurationAggregate {
    private static final List<EventWithState> EMPTY_EVENTS = ImmutableList.of();
    private final AggregateId aggregateId;
    private final History history;
    private State state;

    static ConfigurationAggregate load(AggregateId aggregateId, History history) {
        return new ConfigurationAggregate(aggregateId, history);
    }

    ConfigurationAggregate(AggregateId aggregateId, History history) {
        this.aggregateId = aggregateId;
        this.history = history;
        this.state = State.initial();
        history.getEventsJava().forEach(this::apply);
    }

    List<EventWithState> registerConfiguration(CassandraMailQueueViewConfiguration configuration) {
        boolean isSame = this.state.maybeConfiguration.map(configuration::equals).orElse(false);
        if (isSame) {
            return EMPTY_EVENTS;
        }
        this.state.maybeConfiguration.ifPresent(oldConfiguration -> oldConfiguration.validateConfigurationChange(configuration));
        return ImmutableList.of((Object)EventWithState.noState((Event)new ConfigurationChanged(this.aggregateId, this.history.getNextEventId(), configuration)));
    }

    Optional<CassandraMailQueueViewConfiguration> getCurrentConfiguration() {
        return this.state.maybeConfiguration;
    }

    private void apply(Event event) {
        if (event instanceof ConfigurationChanged) {
            ConfigurationChanged configurationChanged = (ConfigurationChanged)event;
            this.state = this.state.set(configurationChanged.getConfiguration());
        }
    }

    private static class State {
        private Optional<CassandraMailQueueViewConfiguration> maybeConfiguration;

        private static State initial() {
            return new State(Optional.empty());
        }

        State(Optional<CassandraMailQueueViewConfiguration> maybeConfiguration) {
            Preconditions.checkNotNull(maybeConfiguration);
            this.maybeConfiguration = maybeConfiguration;
        }

        State set(CassandraMailQueueViewConfiguration configuration) {
            return new State(Optional.of(configuration));
        }
    }
}

