/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.internal.core.cql.PagingIterableSpliterator;
import com.datastax.oss.driver.shaded.guava.common.collect.AbstractIterator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Function;

public class PagingIterableWrapper<SourceT, TargetT>
implements PagingIterable<TargetT> {
    private final PagingIterable<SourceT> source;
    private final boolean sized;
    private final Iterator<TargetT> iterator;

    public PagingIterableWrapper(@NonNull PagingIterable<SourceT> source, @NonNull Function<? super SourceT, ? extends TargetT> elementMapper) {
        this(source, elementMapper, false);
    }

    public PagingIterableWrapper(@NonNull PagingIterable<SourceT> source, final @NonNull Function<? super SourceT, ? extends TargetT> elementMapper, boolean sized) {
        this.source = source;
        this.sized = sized;
        final Iterator sourceIterator = source.iterator();
        this.iterator = new AbstractIterator<TargetT>(){

            protected TargetT computeNext() {
                return sourceIterator.hasNext() ? elementMapper.apply(sourceIterator.next()) : this.endOfData();
            }
        };
    }

    @Override
    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.source.getColumnDefinitions();
    }

    @Override
    @NonNull
    public List<ExecutionInfo> getExecutionInfos() {
        return this.source.getExecutionInfos();
    }

    @Override
    public boolean isFullyFetched() {
        return this.source.isFullyFetched();
    }

    @Override
    public int getAvailableWithoutFetching() {
        return this.source.getAvailableWithoutFetching();
    }

    @Override
    public boolean wasApplied() {
        return this.source.wasApplied();
    }

    @Override
    @NonNull
    public Iterator<TargetT> iterator() {
        return this.iterator;
    }

    @Override
    @NonNull
    public Spliterator<TargetT> spliterator() {
        PagingIterableSpliterator.Builder builder = PagingIterableSpliterator.builder(this);
        if (this.sized) {
            builder.withEstimatedSize(this.getAvailableWithoutFetching());
        }
        return builder.build();
    }

    @Override
    @NonNull
    public <NewTargetT> PagingIterable<NewTargetT> map(Function<? super TargetT, ? extends NewTargetT> elementMapper) {
        return new PagingIterableWrapper<TargetT, NewTargetT>(this, elementMapper, this.sized);
    }
}

