/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.util.concurrent;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;

public class BoundedConcurrentQueue<ElementT> {
    private final Deque<ElementT> elements = new ConcurrentLinkedDeque<ElementT>();
    private final AtomicReference<State> state;

    public BoundedConcurrentQueue(int maxSize) {
        this.state = new AtomicReference<State>(new State(maxSize));
    }

    @NonNull
    public CompletionStage<ElementT> offer(@NonNull ElementT element) {
        State newState;
        State oldState;
        while (!this.state.compareAndSet(oldState = this.state.get(), newState = oldState.increment())) {
        }
        if (newState.spaceAvailable != null) {
            return newState.spaceAvailable.thenApply(aVoid -> {
                this.elements.offer(element);
                return element;
            });
        }
        this.elements.offer(element);
        return CompletableFuture.completedFuture(element);
    }

    @Nullable
    public ElementT poll() {
        State newState;
        State oldState;
        do {
            oldState = this.state.get();
            if (oldState.size != 0) continue;
            return null;
        } while (!this.state.compareAndSet(oldState, newState = oldState.decrement()));
        if (oldState.spaceAvailable != null) {
            oldState.spaceAvailable.complete(null);
        }
        return this.elements.poll();
    }

    @Nullable
    public ElementT peek() {
        return this.elements.peek();
    }

    public void clear() {
        this.elements.clear();
    }

    private static class State {
        private final int maxSize;
        final int size;
        final CompletableFuture<Void> spaceAvailable;

        State(int maxSize) {
            this(0, null, maxSize);
        }

        private State(int size, CompletableFuture<Void> spaceAvailable, int maxSize) {
            this.maxSize = maxSize;
            this.size = size;
            this.spaceAvailable = spaceAvailable;
        }

        State increment() {
            if (this.size > this.maxSize) {
                throw new IllegalStateException("Can't call offer() until the stage returned by the previous offer() call has completed");
            }
            int newSize = this.size + 1;
            CompletableFuture<Void> newFuture = newSize == this.maxSize + 1 ? new CompletableFuture<Void>() : null;
            return new State(newSize, newFuture, this.maxSize);
        }

        State decrement() {
            return new State(this.size - 1, null, this.maxSize);
        }
    }
}

