/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.objectstorage.aws.sse;

import com.google.common.hash.Hashing;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class S3SSECustomerKeyGenerator {
    public static final int ITERATION_COUNT = 65536;
    public static final int KEY_LENGTH = 256;
    private final SecretKeyFactory secretKeyFactory;

    public S3SSECustomerKeyGenerator() throws NoSuchAlgorithmException {
        this("PBKDF2WithHmacSHA256");
    }

    public S3SSECustomerKeyGenerator(String customerKeyFactoryAlgorithm) throws NoSuchAlgorithmException {
        this.secretKeyFactory = SecretKeyFactory.getInstance(customerKeyFactoryAlgorithm);
    }

    public String generateCustomerKey(String masterPassword, String salt) throws InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(masterPassword.toCharArray(), salt.getBytes(), 65536, 256);
        byte[] derivedKey = this.secretKeyFactory.generateSecret(spec).getEncoded();
        return Base64.getEncoder().encodeToString(derivedKey);
    }

    public String generateCustomerKeyMd5(String customerKey) {
        return Base64.getEncoder().encodeToString(Hashing.md5().hashBytes(Base64.getDecoder().decode(customerKey)).asBytes());
    }
}

