/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.netty;

import com.google.common.annotations.VisibleForTesting;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.james.protocols.api.ClientAuth;

public interface Encryption {
    @VisibleForTesting
    public static Encryption createTls(SSLContext context) {
        return Encryption.createTls(context, null, null, ClientAuth.NONE);
    }

    public static Encryption createTls(SSLContext context, String[] enabledCipherSuites, String[] enabledProtocols, ClientAuth clientAuth) {
        return new LegacyJavaEncryption(context, false, enabledCipherSuites, enabledProtocols, clientAuth);
    }

    @VisibleForTesting
    public static Encryption createStartTls(SSLContext context) {
        return Encryption.createStartTls(context, null, null, ClientAuth.NONE);
    }

    public static Encryption createStartTls(SSLContext context, String[] enabledCipherSuites, String[] enabledProtocols, ClientAuth clientAuth) {
        return new LegacyJavaEncryption(context, true, enabledCipherSuites, enabledProtocols, clientAuth);
    }

    public boolean isStartTLS();

    public boolean supportsEncryption();

    public String[] getEnabledCipherSuites();

    public ClientAuth getClientAuth();

    public SslHandler sslHandler();

    public static class LegacyJavaEncryption
    implements Encryption {
        private final SSLContext context;
        private final boolean starttls;
        private final String[] enabledCipherSuites;
        private final String[] enabledProtocols;
        private final ClientAuth clientAuth;

        private LegacyJavaEncryption(SSLContext context, boolean starttls, String[] enabledCipherSuites, String[] enabledProtocols, ClientAuth clientAuth) {
            this.context = context;
            this.starttls = starttls;
            this.enabledCipherSuites = enabledCipherSuites;
            this.enabledProtocols = enabledProtocols;
            this.clientAuth = clientAuth;
        }

        public SSLContext getContext() {
            return this.context;
        }

        @Override
        public boolean isStartTLS() {
            return this.starttls;
        }

        @Override
        public boolean supportsEncryption() {
            return this.context != null;
        }

        @Override
        public String[] getEnabledCipherSuites() {
            return this.enabledCipherSuites;
        }

        @Override
        public ClientAuth getClientAuth() {
            return this.clientAuth;
        }

        private SSLEngine createSSLEngine() {
            SSLEngine engine = this.context.createSSLEngine();
            String[] cipherSuites = (String[])ArrayUtils.clone((Object[])this.enabledCipherSuites);
            String[] protocols = (String[])ArrayUtils.clone((Object[])this.enabledProtocols);
            if (cipherSuites != null && cipherSuites.length > 0) {
                engine.setEnabledCipherSuites(cipherSuites);
            }
            if (protocols != null && protocols.length > 0) {
                engine.setEnabledProtocols(protocols);
            }
            if (ClientAuth.NEED.equals((Object)this.clientAuth)) {
                engine.setNeedClientAuth(true);
            }
            if (ClientAuth.WANT.equals((Object)this.clientAuth)) {
                engine.setWantClientAuth(true);
            }
            return engine;
        }

        @Override
        public SslHandler sslHandler() {
            SSLEngine engine = this.createSSLEngine();
            engine.setUseClientMode(false);
            return new SslHandler(engine);
        }
    }

    public static interface Factory {
        public Encryption create() throws Exception;
    }
}

