/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.auto$;
import eu.timepit.refined.string;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.model.AccountId;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.ErrorCode$InvalidArguments$;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.core.UuidState$;
import org.apache.james.jmap.json.EmailGetSerializer$;
import org.apache.james.jmap.mail.Email$;
import org.apache.james.jmap.mail.EmailGetRequest;
import org.apache.james.jmap.mail.EmailGetResponse;
import org.apache.james.jmap.mail.EmailIds;
import org.apache.james.jmap.mail.EmailView;
import org.apache.james.jmap.mail.EmailViewReaderFactory;
import org.apache.james.jmap.mail.UnparsedEmailId;
import org.apache.james.jmap.method.EmailGetMethod$;
import org.apache.james.jmap.method.EmailGetResults;
import org.apache.james.jmap.method.EmailGetResults$;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.method.package$;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\tus!B\u0010!\u0011\u0003Yc!B\u0017!\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004bB\u001c\u0002\u0005\u0004%I\u0001\u000f\u0005\u0007\u007f\u0005\u0001\u000b\u0011B\u001d\u0007\t5\u0002\u0003\u0001\u0011\u0005\t\u0015\u0016\u0011\t\u0011)A\u0005\u0017\"Aa*\u0002B\u0001B\u0003%q\n\u0003\u0005\\\u000b\t\u0015\r\u0011\"\u0001]\u0011!)WA!A!\u0002\u0013i\u0006\u0002\u00034\u0006\u0005\u000b\u0007I\u0011A4\t\u0011=,!\u0011!Q\u0001\n!D\u0001\u0002]\u0003\u0003\u0006\u0004%\t!\u001d\u0005\tq\u0016\u0011\t\u0011)A\u0005e\"A\u00110\u0002BC\u0002\u0013\u0005!\u0010C\u0005\u0002\u0004\u0015\u0011\t\u0011)A\u0005w\"Q\u0011QA\u0003\u0003\u0006\u0004%\t!a\u0002\t\u0015\u0005=QA!A!\u0002\u0013\tI\u0001\u0003\u00046\u000b\u0011\u0005\u0011\u0011\u0003\u0005\n\u0003k)!\u0019!C!\u0003oA\u0001\"!\u0019\u0006A\u0003%\u0011\u0011\b\u0005\n\u0003G*!\u0019!C!\u0003KB\u0001\"!\"\u0006A\u0003%\u0011q\r\u0005\b\u0003\u000f+A\u0011IAE\u0011\u001d\ti,\u0002C!\u0003\u007fCq!a9\u0006\t\u0013\t)\u000fC\u0004\u0002r\u0016!I!a=\t\u000f\t\rQ\u0001\"\u0003\u0003\u0006!9\u0011\u0011_\u0003\u0005\n\tM\u0001b\u0002B\u0016\u000b\u0011%!Q\u0006\u0005\b\u0005\u000f*A\u0011\u0002B%\u00039)U.Y5m\u000f\u0016$X*\u001a;i_\u0012T!!\t\u0012\u0002\r5,G\u000f[8e\u0015\t\u0019C%\u0001\u0003k[\u0006\u0004(BA\u0013'\u0003\u0015Q\u0017-\\3t\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\u0004\u0001A\u0011A&A\u0007\u0002A\tqQ)\\1jY\u001e+G/T3uQ>$7CA\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aK\u0001\u0007Y><w-\u001a:\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR!\u0001\u0010\u0015\u0002\u000bMdg\r\u000e6\n\u0005yZ$A\u0002'pO\u001e,'/A\u0004m_\u001e<WM\u001d\u0011\u0014\u0007\u0015y\u0013\tE\u0002-\u0005\u0012K!a\u0011\u0011\u000315+G\u000f[8e%\u0016\fX/\u001b:j]\u001e\f5mY8v]RLE\r\u0005\u0002F\u00116\taI\u0003\u0002HE\u0005!Q.Y5m\u0013\tIeIA\bF[\u0006LGnR3u%\u0016\fX/Z:u\u00035\u0011X-\u00193fe\u001a\u000b7\r^8ssB\u0011Q\tT\u0005\u0003\u001b\u001a\u0013a#R7bS24\u0016.Z<SK\u0006$WM\u001d$bGR|'/_\u0001\u0011[\u0016\u001c8/Y4f\u0013\u00124\u0015m\u0019;pef\u0004\"\u0001\u0015-\u000f\u0005E3V\"\u0001*\u000b\u0005M#\u0016!B7pI\u0016d'BA+%\u0003\u001di\u0017-\u001b7c_bL!a\u0016*\u0002\u00135+7o]1hK&#\u0017BA-[\u0005\u001d1\u0015m\u0019;pefT!a\u0016*\u0002\u001b5,GO]5d\r\u0006\u001cGo\u001c:z+\u0005i\u0006C\u00010d\u001b\u0005y&B\u00011b\u0003\r\t\u0007/\u001b\u0006\u0003E\u0012\nq!\\3ue&\u001c7/\u0003\u0002e?\niQ*\u001a;sS\u000e4\u0015m\u0019;pef\fa\"\\3ue&\u001cg)Y2u_JL\b%A\u000bf[\u0006LGn\u00195b]\u001e,'+\u001a9pg&$xN]=\u0016\u0003!\u0004\"![7\u000e\u0003)T!a\u001b7\u0002\r\rD\u0017M\\4f\u0015\t\u0001'%\u0003\u0002oU\n)R)\\1jY\u000eC\u0017M\\4f%\u0016\u0004xn]5u_JL\u0018AF3nC&d7\r[1oO\u0016\u0014V\r]8tSR|'/\u001f\u0011\u0002\u001fM,7o]5p]N+\b\u000f\u001d7jKJ,\u0012A\u001d\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k\n\naA]8vi\u0016\u001c\u0018BA<u\u0005=\u0019Vm]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\u0018\u0001E:fgNLwN\\*vaBd\u0017.\u001a:!\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]V\t1\u0010\u0005\u0002}\u007f6\tQP\u0003\u0002\u007fE\u0005!1m\u001c:f\u0013\r\t\t! \u0002\u0019\u00156\f\u0007O\u00154dqY\u0012\u0014gQ8oM&<WO]1uS>t\u0017AD2p]\u001aLw-\u001e:bi&|g\u000eI\u0001\u0012g\u0016\u001c8/[8o)J\fgn\u001d7bi>\u0014XCAA\u0005!\ra\u00181B\u0005\u0004\u0003\u001bi(!E*fgNLwN\u001c+sC:\u001cH.\u0019;pe\u0006\u00112/Z:tS>tGK]1og2\fGo\u001c:!)A\t\u0019\"!\u0006\u0002\u0018\u0005e\u00111DA\u000f\u0003?\t\t\u0003\u0005\u0002-\u000b!)!J\u0005a\u0001\u0017\")aJ\u0005a\u0001\u001f\")1L\u0005a\u0001;\")aM\u0005a\u0001Q\")\u0001O\u0005a\u0001e\")\u0011P\u0005a\u0001w\"9\u0011Q\u0001\nA\u0002\u0005%\u0001f\u0001\n\u0002&A!\u0011qEA\u0019\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012AB5oU\u0016\u001cGO\u0003\u0002\u00020\u00059!.Y6beR\f\u0017\u0002BA\u001a\u0003S\u0011a!\u00138kK\u000e$\u0018AC7fi\"|GMT1nKV\u0011\u0011\u0011\b\t\u0005\u0003w\tYF\u0004\u0003\u0002>\u0005]c\u0002BA \u0003+rA!!\u0011\u0002T9!\u00111IA)\u001d\u0011\t)%a\u0014\u000f\t\u0005\u001d\u0013QJ\u0007\u0003\u0003\u0013R1!a\u0013+\u0003\u0019a$o\\8u}%\t\u0011&\u0003\u0002(Q%\u0011QEJ\u0005\u0003G\u0011J!A \u0012\n\u0007\u0005eS0\u0001\u0006J]Z|7-\u0019;j_:LA!!\u0018\u0002`\tQQ*\u001a;i_\u0012t\u0015-\\3\u000b\u0007\u0005eS0A\u0006nKRDw\u000e\u001a(b[\u0016\u0004\u0013\u0001\u0006:fcVL'/\u001a3DCB\f'-\u001b7ji&,7/\u0006\u0002\u0002hA1\u0011\u0011NA9\u0003orA!a\u001b\u0002nA\u0019\u0011qI\u0019\n\u0007\u0005=\u0014'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\n)HA\u0002TKRT1!a\u001c2!\u0011\tI(a \u000f\t\u0005u\u00121P\u0005\u0004\u0003{j\u0018\u0001F\"ba\u0006\u0014\u0017\u000e\\5us&#WM\u001c;jM&,'/\u0003\u0003\u0002\u0002\u0006\r%\u0001F\"ba\u0006\u0014\u0017\u000e\\5us&#WM\u001c;jM&,'OC\u0002\u0002~u\fQC]3rk&\u0014X\rZ\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\b%A\u0005e_B\u0013xnY3tgRQ\u00111RAS\u0003S\u000bi+!/\u0011\r\u00055\u00151TAP\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015!\u00039vE2L7\u000f[3s\u0015\r\u0011\u0014Q\u0013\u0006\u0004}\u0006]%BAAM\u0003\u001d\u0011X-Y2u_JLA!!(\u0002\u0010\n)1+T8o_B\u0019A&!)\n\u0007\u0005\r\u0006EA\u000bJ]Z|7-\u0019;j_:<\u0016\u000e\u001e5D_:$X\r\u001f;\t\u000f\u0005\u001dv\u00031\u0001\u0002h\u0005a1-\u00199bE&d\u0017\u000e^5fg\"9\u00111V\fA\u0002\u0005}\u0015AC5om>\u001c\u0017\r^5p]\"9\u0011qV\fA\u0002\u0005E\u0016AD7bS2\u0014w\u000e_*fgNLwN\u001c\t\u0005\u0003g\u000b),D\u0001U\u0013\r\t9\f\u0016\u0002\u000f\u001b\u0006LGNY8y'\u0016\u001c8/[8o\u0011\u0019\tYl\u0006a\u0001\t\u00069!/Z9vKN$\u0018AC4fiJ+\u0017/^3tiR1\u0011\u0011YAm\u00037\u0004r!a1\u0002N\u0006MGI\u0004\u0003\u0002F\u0006%g\u0002BA$\u0003\u000fL\u0011AM\u0005\u0004\u0003\u0017\f\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003\u001f\f\tN\u0001\u0004FSRDWM\u001d\u0006\u0004\u0003\u0017\f\u0004\u0003BAb\u0003+LA!a6\u0002R\nA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\t\u000f\u0005=\u0006\u00041\u0001\u00022\"9\u00111\u0016\rA\u0002\u0005u\u0007c\u0001?\u0002`&\u0019\u0011\u0011]?\u0003\u0015%sgo\\2bi&|g.A\rd_6\u0004X\u000f^3SKN\u0004xN\\:f\u0013:4xnY1uS>tGCCAt\u0003S\fY/!<\u0002pB1\u0011QRAN\u0003;Dq!a*\u001a\u0001\u0004\t9\u0007\u0003\u0004\u0002<f\u0001\r\u0001\u0012\u0005\b\u0003WK\u0002\u0019AAo\u0011\u001d\ty+\u0007a\u0001\u0003c\u000b\u0011bZ3u\u000b6\f\u0017\u000e\\:\u0015\u0011\u0005U\u0018Q`A\u0000\u0005\u0003\u0001b!!$\u0002\u001c\u0006]\bcA#\u0002z&\u0019\u00111 $\u0003!\u0015k\u0017-\u001b7HKR\u0014Vm\u001d9p]N,\u0007bBAT5\u0001\u0007\u0011q\r\u0005\u0007\u0003wS\u0002\u0019\u0001#\t\u000f\u0005=&\u00041\u0001\u00022\u0006i!/\u001a;sS\u00164Xm\u0015;bi\u0016$bAa\u0002\u0003\u0010\tE\u0001CBAG\u00037\u0013I\u0001E\u0002j\u0005\u0017I1A!\u0004k\u0005\u0015\u0019F/\u0019;f\u0011\u001d\t9k\u0007a\u0001\u0003OBq!a,\u001c\u0001\u0004\t\t\f\u0006\u0005\u0003\u0016\tu!q\u0005B\u0015!\u0019\ti)a'\u0003\u0018A\u0019AF!\u0007\n\u0007\tm\u0001EA\bF[\u0006LGnR3u%\u0016\u001cX\u000f\u001c;t\u0011\u001d\u0011y\u0002\ba\u0001\u0005C\t1!\u001b3t!\r)%1E\u0005\u0004\u0005K1%\u0001C#nC&d\u0017\nZ:\t\u000f\u0005=F\u00041\u0001\u00022\"1\u00111\u0018\u000fA\u0002\u0011\u000b1\"Y:NKN\u001c\u0018mZ3JIR!!q\u0006B\"!!\t\u0019-!4\u00032\tu\u0002c\u0002\u0019\u00034\t]\u00121[\u0005\u0004\u0005k\t$A\u0002+va2,'\u0007E\u0002F\u0005sI1Aa\u000fG\u0005=)f\u000e]1sg\u0016$W)\\1jY&#\u0007cA)\u0003@%\u0019!\u0011\t*\u0003\u00135+7o]1hK&#\u0007b\u0002B#;\u0001\u0007!qG\u0001\u0003S\u0012\faB]3ue&,g/Z#nC&d7\u000f\u0006\u0005\u0003L\tE#\u0011\fB.!\u0019\tiI!\u0014\u0003\u0018%!!qJAH\u0005\u0015\u0019f\t\\;y\u0011\u001d\u0011yB\ba\u0001\u0005'\u0002b!a1\u0003V\tu\u0012\u0002\u0002B,\u0003#\u00141aU3r\u0011\u001d\tyK\ba\u0001\u0003cCa!a/\u001f\u0001\u0004!\u0005")
public class EmailGetMethod
implements MethodRequiringAccountId<EmailGetRequest> {
    private final EmailViewReaderFactory readerFactory;
    private final MessageId.Factory messageIdFactory;
    private final MetricFactory metricFactory;
    private final EmailChangeRepository emailchangeRepository;
    private final SessionSupplier sessionSupplier;
    private final JmapRfc8621Configuration configuration;
    private final SessionTranslator sessionTranslator;
    private final Invocation.MethodName methodName;
    private final Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    public EmailChangeRepository emailchangeRepository() {
        return this.emailchangeRepository;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    public JmapRfc8621Configuration configuration() {
        return this.configuration;
    }

    @Override
    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public SMono<InvocationWithContext> doProcess(Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, EmailGetRequest request) {
        return this.computeResponseInvocation(capabilities, request, invocation.invocation(), mailboxSession).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                return SMono$.MODULE$.just((Object)Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, illegalArgumentException.getMessage(), invocation.invocation().methodCallId()));
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                return SMono$.MODULE$.error(throwable2);
            }
            throw new MatchError((Object)throwable);
        }).map((Function1 & Serializable)invocationResult -> new InvocationWithContext((Invocation)invocationResult, invocation.processingContext()));
    }

    @Override
    public Either<IllegalArgumentException, EmailGetRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        return package$.MODULE$.AsEitherRequest(EmailGetSerializer$.MODULE$.deserializeEmailGetRequest((JsValue)invocation.arguments())).asEitherRequest();
    }

    private SMono<Invocation> computeResponseInvocation(Set<Refined<String, string.Uri>> capabilities, EmailGetRequest request, Invocation invocation, MailboxSession mailboxSession) {
        Either either = Email$.MODULE$.validateProperties(request.properties()).flatMap((Function1 & Serializable)properties -> Email$.MODULE$.validateBodyProperties(request.bodyProperties()).flatMap((Function1 & Serializable)bodyProperties -> request.validate(this.configuration()).map((Function1 & Serializable)x$1 -> {
            EmailGetRequest emailGetRequest = x$1;
            return this.getEmails(capabilities, request, mailboxSession).map((Function1 & Serializable)response -> new Invocation(this.methodName(), (JsObject)EmailGetSerializer$.MODULE$.serialize((EmailGetResponse)response, (Properties)properties, (Properties)bodyProperties).as((Reads)Reads$.MODULE$.JsObjectReads()), invocation.methodCallId()));
        })));
        return (SMono)either.fold((Function1 & Serializable)exception -> SMono$.MODULE$.error(exception), (Function1 & Serializable)v -> v);
    }

    private SMono<EmailGetResponse> getEmails(Set<Refined<String, string.Uri>> capabilities, EmailGetRequest request, MailboxSession mailboxSession) {
        Option<EmailIds> option = request.ids();
        if (None$.MODULE$.equals(option)) {
            return SMono$.MODULE$.error((Throwable)new IllegalArgumentException("ids can not be ommited for email/get"));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            EmailIds ids = (EmailIds)some.value();
            return this.getEmails(ids, mailboxSession, request).flatMap((Function1 & Serializable)result -> this.retrieveState(capabilities, mailboxSession).map((Function1 & Serializable)state -> new EmailGetResponse(request.accountId(), UuidState$.MODULE$.fromJava((State)state), (List<EmailView>)result.emails().toList(), result.notFound())));
        }
        throw new MatchError(option);
    }

    private SMono<State> retrieveState(Set<Refined<String, string.Uri>> capabilities, MailboxSession mailboxSession) {
        AccountId accountId = AccountId.fromUsername((Username)mailboxSession.getUser());
        if (capabilities.contains((Object)new Refined((Object)CapabilityIdentifier$.MODULE$.JAMES_SHARES()))) {
            return SMono$.MODULE$.apply((Publisher)this.emailchangeRepository().getLatestStateWithDelegation(accountId));
        }
        return SMono$.MODULE$.apply((Publisher)this.emailchangeRepository().getLatestState(accountId));
    }

    private SMono<EmailGetResults> getEmails(EmailIds ids, MailboxSession mailboxSession, EmailGetRequest request) {
        List parsedIds = ids.value().map((Function1 & Serializable)id -> this.asMessageId((UnparsedEmailId)id));
        List messagesIds = parsedIds.flatMap((Function1 & Serializable)x0$1 -> {
            Either either = x0$1;
            if (either instanceof Left) {
                return None$.MODULE$;
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                MessageId messageId = (MessageId)right.value();
                return new Some((Object)messageId);
            }
            throw new MatchError((Object)either);
        });
        SFlux parsingErrors = SFlux$.MODULE$.fromIterable((Iterable)parsedIds.flatMap((Function1 & Serializable)x0$2 -> {
            Left left;
            Tuple2 tuple2;
            Either either = x0$2;
            if (either instanceof Left && (tuple2 = (Tuple2)(left = (Left)either).value()) != null) {
                UnparsedEmailId id = (UnparsedEmailId)tuple2._1();
                IllegalArgumentException error = (IllegalArgumentException)tuple2._2();
                EmailGetMethod$.MODULE$.org$apache$james$jmap$method$EmailGetMethod$$logger().warn("id parsing failed", (Throwable)error);
                return new Some((Object)EmailGetResults$.MODULE$.notFound(id));
            }
            if (either instanceof Right) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        }));
        return SFlux$.MODULE$.merge((Seq)new .colon.colon(this.retrieveEmails((Seq<MessageId>)messagesIds, mailboxSession, request), (List)new .colon.colon((Object)parsingErrors, (List)Nil$.MODULE$)), SFlux$.MODULE$.merge$default$2(), SFlux$.MODULE$.merge$default$3()).reduce((Object)EmailGetResults$.MODULE$.empty(), (Function2 & Serializable)(result1, result2) -> EmailGetResults$.MODULE$.merge((EmailGetResults)result1, (EmailGetResults)result2));
    }

    private Either<Tuple2<UnparsedEmailId, IllegalArgumentException>, MessageId> asMessageId(UnparsedEmailId id) {
        Right right;
        try {
            right = new Right((Object)this.messageIdFactory.fromString((String)auto$.MODULE$.autoUnwrap((Object)new Refined((Object)id.id()), RefType$.MODULE$.refinedRefType())));
        }
        catch (Exception e) {
            right = new Left((Object)new Tuple2((Object)id, (Object)new IllegalArgumentException(e)));
        }
        return right;
    }

    private SFlux<EmailGetResults> retrieveEmails(Seq<MessageId> ids, MailboxSession mailboxSession, EmailGetRequest request) {
        SMono foundResultsMono = this.readerFactory.selectReader(request).read(ids, request, mailboxSession).collectMap((Function1 & Serializable)x$2 -> x$2.metadata().id());
        return foundResultsMono.flatMapIterable((Function1 & Serializable)foundResults -> (Seq)ids.map((Function1 & Serializable)id -> (EmailGetResults)foundResults.get(id).map((Function1 & Serializable)email -> EmailGetResults$.MODULE$.found((EmailView)email)).getOrElse((Function0 & Serializable)() -> EmailGetResults$.MODULE$.notFound((MessageId)id))));
    }

    @Inject
    public EmailGetMethod(EmailViewReaderFactory readerFactory, MessageId.Factory messageIdFactory, MetricFactory metricFactory, EmailChangeRepository emailchangeRepository, SessionSupplier sessionSupplier, JmapRfc8621Configuration configuration, SessionTranslator sessionTranslator) {
        this.readerFactory = readerFactory;
        this.messageIdFactory = messageIdFactory;
        this.metricFactory = metricFactory;
        this.emailchangeRepository = emailchangeRepository;
        this.sessionSupplier = sessionSupplier;
        this.configuration = configuration;
        this.sessionTranslator = sessionTranslator;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"Email/get")).value());
        this.requiredCapabilities = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_MAIL())}));
        Statics.releaseFence();
    }
}

