/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import jakarta.mail.MessagingException;
import java.util.Collection;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.mailet.DsnParameters;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class DSNSuccessRequested
extends GenericMatcher {
    private static final boolean DEFAULT_PRESENT = true;
    public static final String CONDITION = "shouldMatchByDefault";
    private boolean shouldBeMatchedByDefault;

    public void init() throws MessagingException {
        Preconditions.checkState((Strings.isNullOrEmpty((String)this.getCondition()) || CONDITION.equals(this.getCondition()) ? 1 : 0) != 0, (String)"DSNSuccessRequested condition, when specified, should be '%s'", (Object)CONDITION);
        this.shouldBeMatchedByDefault = Optional.ofNullable(this.getCondition()).map(CONDITION::equals).orElse(false);
    }

    public Collection<MailAddress> match(Mail mail) {
        return (Collection)mail.getRecipients().stream().filter(recipient -> this.successRequested(mail, (MailAddress)recipient)).collect(ImmutableList.toImmutableList());
    }

    private Boolean successRequested(Mail mail, MailAddress recipient) {
        return mail.dsnParameters().map(dsnParameters -> this.successRequested(recipient, (DsnParameters)dsnParameters)).orElse(this.shouldBeMatchedByDefault);
    }

    private boolean successRequested(MailAddress recipient, DsnParameters dsnParameters) {
        return Optional.ofNullable((DsnParameters.RecipientDsnParameters)dsnParameters.getRcptParameters().get((Object)recipient)).map(rcptParams -> rcptParams.getNotifyParameter().map(notifies -> notifies.contains(DsnParameters.Notify.SUCCESS)).orElse(this.shouldBeMatchedByDefault)).orElse(this.shouldBeMatchedByDefault);
    }

    public String getMatcherName() {
        return "DSNSuccessRequested";
    }
}

