/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import jakarta.inject.Inject;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.james.util.html.HtmlTextExtractor;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class ToPlainText
extends GenericMailet {
    private final HtmlTextExtractor htmlTextExtractor;

    @Inject
    public ToPlainText(HtmlTextExtractor htmlTextExtractor) {
        this.htmlTextExtractor = htmlTextExtractor;
    }

    public void service(Mail mail) throws MessagingException {
        try {
            if (this.removeHtmlFromMultipartAlternative(mail.getMessage()) || this.convertRemainingHtmlToPlainText(mail.getMessage())) {
                mail.getMessage().saveChanges();
            }
        }
        catch (Exception e) {
            throw new MessagingException("Exception while extracting HTML", e);
        }
    }

    private boolean removeHtmlFromMultipartAlternative(MimeMessage mimeMessage) throws IOException, MessagingException {
        if (mimeMessage.getContent() instanceof Multipart) {
            Multipart multipart = (Multipart)mimeMessage.getContent();
            return this.removeHtmlFromMultipartAlternativeForContent(multipart);
        }
        return false;
    }

    private boolean removeHtmlFromMultipartAlternative(BodyPart bodyPart) throws IOException, MessagingException {
        if (bodyPart.getContent() instanceof Multipart) {
            Multipart multipart = (Multipart)bodyPart.getContent();
            return this.removeHtmlFromMultipartAlternativeForContent(multipart);
        }
        return false;
    }

    private boolean removeHtmlFromMultipartAlternativeForContent(Multipart multipart) throws MessagingException, IOException {
        boolean mutated = false;
        if (multipart.getContentType().startsWith("multipart/alternative")) {
            int removedParts = 0;
            for (int i = 0; i < multipart.getCount(); ++i) {
                if (!multipart.getBodyPart(i + removedParts).getContentType().startsWith("text/html")) continue;
                multipart.removeBodyPart(i + removedParts);
                ++removedParts;
                mutated = true;
            }
        } else {
            for (int i = 0; i < multipart.getCount(); ++i) {
                mutated = this.removeHtmlFromMultipartAlternative(multipart.getBodyPart(i));
            }
        }
        return mutated;
    }

    private boolean convertRemainingHtmlToPlainText(MimeMessage mimeMessage) throws IOException, MessagingException {
        if (mimeMessage.getContentType().startsWith("text/html")) {
            mimeMessage.setContent((Object)this.htmlTextExtractor.toPlainText(IOUtils.toString((InputStream)mimeMessage.getInputStream())), "text/plain");
            return true;
        }
        if (mimeMessage.getContent() instanceof Multipart) {
            Multipart multipart = (Multipart)mimeMessage.getContent();
            return this.multipartHtmlToText(multipart);
        }
        return false;
    }

    private boolean convertRemainingHtmlToPlainText(BodyPart bodyPart) throws IOException, MessagingException {
        if (bodyPart.getContent() instanceof Multipart) {
            Multipart multipart = (Multipart)bodyPart.getContent();
            return this.multipartHtmlToText(multipart);
        }
        if (bodyPart.getContentType().startsWith("text/html")) {
            bodyPart.setContent((Object)this.htmlTextExtractor.toPlainText(IOUtils.toString((InputStream)bodyPart.getInputStream())), "text/plain");
            return true;
        }
        return false;
    }

    private boolean multipartHtmlToText(Multipart multipart) throws MessagingException, IOException {
        boolean mutated = false;
        for (int i = 0; i < multipart.getCount(); ++i) {
            mutated |= this.convertRemainingHtmlToPlainText(multipart.getBodyPart(i));
        }
        return mutated;
    }

    public String getMailetName() {
        return "ToPlainText";
    }
}

