/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class NodeBufferPool
implements PlainJsonSerializable {
    private final long count;
    private final long totalCapacityInBytes;
    private final long usedInBytes;
    public static final JsonpDeserializer<NodeBufferPool> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeBufferPool::setupNodeBufferPoolDeserializer);

    private NodeBufferPool(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.totalCapacityInBytes = ApiTypeHelper.requireNonNull(builder.totalCapacityInBytes, this, "totalCapacityInBytes");
        this.usedInBytes = ApiTypeHelper.requireNonNull(builder.usedInBytes, this, "usedInBytes");
    }

    public static NodeBufferPool of(Function<Builder, ObjectBuilder<NodeBufferPool>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final long totalCapacityInBytes() {
        return this.totalCapacityInBytes;
    }

    public final long usedInBytes() {
        return this.usedInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("total_capacity_in_bytes");
        generator.write(this.totalCapacityInBytes);
        generator.writeKey("used_in_bytes");
        generator.write(this.usedInBytes);
    }

    protected static void setupNodeBufferPoolDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::totalCapacityInBytes, JsonpDeserializer.longDeserializer(), "total_capacity_in_bytes");
        op.add(Builder::usedInBytes, JsonpDeserializer.longDeserializer(), "used_in_bytes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NodeBufferPool> {
        private Long count;
        private Long totalCapacityInBytes;
        private Long usedInBytes;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder totalCapacityInBytes(long value) {
            this.totalCapacityInBytes = value;
            return this;
        }

        public final Builder usedInBytes(long value) {
            this.usedInBytes = value;
            return this;
        }

        @Override
        public NodeBufferPool build() {
            this._checkSingleUse();
            return new NodeBufferPool(this);
        }
    }
}

