/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.opensearch._types.aggregations.SingleMetricAggregateBase;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class DerivativeAggregate
extends SingleMetricAggregateBase
implements AggregateVariant {
    @Nullable
    private final Double normalizedValue;
    @Nullable
    private final String normalizedValueAsString;
    public static final JsonpDeserializer<DerivativeAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DerivativeAggregate::setupDerivativeAggregateDeserializer);

    private DerivativeAggregate(Builder builder) {
        super(builder);
        this.normalizedValue = builder.normalizedValue;
        this.normalizedValueAsString = builder.normalizedValueAsString;
    }

    public static DerivativeAggregate of(Function<Builder, ObjectBuilder<DerivativeAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.Derivative;
    }

    @Nullable
    public final Double normalizedValue() {
        return this.normalizedValue;
    }

    @Nullable
    public final String normalizedValueAsString() {
        return this.normalizedValueAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.normalizedValue != null) {
            generator.writeKey("normalized_value");
            generator.write(this.normalizedValue.doubleValue());
        }
        if (this.normalizedValueAsString != null) {
            generator.writeKey("normalized_value_as_string");
            generator.write(this.normalizedValueAsString);
        }
    }

    protected static void setupDerivativeAggregateDeserializer(ObjectDeserializer<Builder> op) {
        DerivativeAggregate.setupSingleMetricAggregateBaseDeserializer(op);
        op.add(Builder::normalizedValue, JsonpDeserializer.doubleDeserializer(), "normalized_value");
        op.add(Builder::normalizedValueAsString, JsonpDeserializer.stringDeserializer(), "normalized_value_as_string");
    }

    public static class Builder
    extends SingleMetricAggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DerivativeAggregate> {
        @Nullable
        private Double normalizedValue;
        @Nullable
        private String normalizedValueAsString;

        public final Builder normalizedValue(@Nullable Double value) {
            this.normalizedValue = value;
            return this;
        }

        public final Builder normalizedValueAsString(@Nullable String value) {
            this.normalizedValueAsString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DerivativeAggregate build() {
            this._checkSingleUse();
            return new DerivativeAggregate(this);
        }
    }
}

