/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.commons.text.RandomStringGenerator;

public class AttachmentId {
    public static final RandomStringGenerator RANDOM_STRING_GENERATOR = new RandomStringGenerator.Builder().withinRange(97, 122).build();
    private final String id;

    public static AttachmentId random() {
        return new AttachmentId(RANDOM_STRING_GENERATOR.generate(20));
    }

    public static AttachmentId from(String id) {
        Preconditions.checkNotNull(id);
        Preconditions.checkArgument(!id.isEmpty());
        return new AttachmentId(id);
    }

    private AttachmentId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public UUID asUUID() {
        return UUID.nameUUIDFromBytes(this.id.getBytes(StandardCharsets.UTF_8));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AttachmentId) {
            AttachmentId other = (AttachmentId)obj;
            return Objects.equal(this.id, other.id);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("id", this.id).toString();
    }
}

