/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.api.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.UUID;

public class UploadId {
    private final UUID id;

    public static UploadId random() {
        return new UploadId(UUID.randomUUID());
    }

    public static UploadId from(String id) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((!id.isEmpty() ? 1 : 0) != 0);
        return new UploadId(UUID.fromString(id));
    }

    public static UploadId from(UUID id) {
        Preconditions.checkNotNull((Object)id);
        return new UploadId(id);
    }

    public UploadId(UUID id) {
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public String asString() {
        return this.id.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof UploadId) {
            UploadId other = (UploadId)obj;
            return Objects.equal((Object)this.id, (Object)other.id);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }
}

