/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetException;
import org.apache.mailet.base.GenericMailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeDecodingMailet
extends GenericMailet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeDecodingMailet.class);
    public static final String ATTRIBUTE_PARAMETER_NAME = "attribute";
    private AttributeName attributeName;

    public void init() throws MessagingException {
        String attributeRaw = this.getInitParameter(ATTRIBUTE_PARAMETER_NAME);
        if (Strings.isNullOrEmpty((String)attributeRaw)) {
            throw new MailetException("No value for attribute parameter was provided.");
        }
        this.attributeName = AttributeName.of((String)attributeRaw);
    }

    public void service(Mail mail) throws MessagingException {
        mail.getAttribute(this.attributeName).ifPresent(Throwing.consumer(attribute -> this.setAttribute(mail, (Attribute)attribute)).sneakyThrow());
    }

    private void setAttribute(Mail mail, Attribute attribute) {
        Function convertToMapContent = Throwing.function(entry -> this.extractContent(((AttributeValue)entry.getValue()).getValue()).stream().map(content -> Pair.of((Object)((String)entry.getKey()), (Object)content))).sneakyThrow();
        Map extractedMimeContentByName = (Map)this.getAttributeContent(attribute).entrySet().stream().flatMap(convertToMapContent).collect(ImmutableMap.toImmutableMap(Pair::getKey, pair -> AttributeValue.of((byte[])((byte[])pair.getValue()))));
        mail.setAttribute(new Attribute(this.attributeName, AttributeValue.of((Map)extractedMimeContentByName)));
    }

    private Map<String, AttributeValue<byte[]>> getAttributeContent(Attribute attribute) {
        Object attributeValue = attribute.getValue().value();
        if (!(attributeValue instanceof Map)) {
            LOGGER.debug("Invalid attribute found into attribute {} class Map expected but {} found.", (Object)attribute, attributeValue.getClass());
            return ImmutableMap.of();
        }
        return (Map)attributeValue;
    }

    private Optional<byte[]> extractContent(Object rawMime) throws MessagingException {
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart((InputStream)new ByteArrayInputStream((byte[])rawMime));
            return Optional.ofNullable(IOUtils.toByteArray((InputStream)mimeBodyPart.getInputStream()));
        }
        catch (IOException e) {
            LOGGER.error("Error while extracting content from mime part", (Throwable)e);
            return Optional.empty();
        }
        catch (ClassCastException e) {
            LOGGER.error("Invalid map attribute types.", (Throwable)e);
            return Optional.empty();
        }
    }

    public String getMailetInfo() {
        return "MimeDecodingMailet";
    }
}

