/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.operator.process.InsertTabletStatementGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.TypeFactory;
import org.apache.tsfile.utils.RamUsageEstimator;

public class TreeInsertTabletStatementGenerator
extends InsertTabletStatementGenerator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(TreeInsertTabletStatementGenerator.class);
    private final Map<String, AtomicLong> writtenCounter = new HashMap<String, AtomicLong>();

    public TreeInsertTabletStatementGenerator(PartialPath targetDevice, Map<String, InputLocation> measurementToInputLocationMap, Map<String, TSDataType> measurementToDataTypeMap, List<TSDataType> inputColumnTypes, boolean isAligned, int rowLimit) {
        super(targetDevice, measurementToInputLocationMap.keySet().toArray(new String[0]), measurementToDataTypeMap.values().toArray(new TSDataType[0]), measurementToInputLocationMap.values().toArray(new InputLocation[0]), (Type[])inputColumnTypes.stream().map(TypeFactory::getType).toArray(Type[]::new), isAligned, rowLimit);
        for (String measurement : this.measurements) {
            this.writtenCounter.put(measurement, new AtomicLong(0L));
        }
        this.initialize();
    }

    @Override
    public int processTsBlock(TsBlock tsBlock, int lastReadIndex) {
        while (lastReadIndex < tsBlock.getPositionCount()) {
            this.times[this.rowCount] = tsBlock.getTimeByIndex(lastReadIndex);
            for (int i = 0; i < this.measurements.length; ++i) {
                int valueColumnIndex = this.inputLocations[i].getValueColumnIndex();
                Column valueColumn = tsBlock.getValueColumns()[valueColumnIndex];
                if (valueColumn.isNull(lastReadIndex)) continue;
                this.bitMaps[i].unmark(this.rowCount);
                this.writtenCounter.get(this.measurements[i]).getAndIncrement();
                this.processColumn(valueColumn, this.columns[i], this.dataTypes[i], this.typeConvertors[valueColumnIndex], lastReadIndex);
            }
            ++this.rowCount;
            ++lastReadIndex;
            if (this.rowCount != this.rowLimit) continue;
            break;
        }
        return lastReadIndex;
    }

    @Override
    public long getWrittenCount() {
        throw new UnsupportedOperationException("getWrittenCount() is not supported");
    }

    @Override
    public long getWrittenCount(String measurement) {
        if (!this.writtenCounter.containsKey(measurement)) {
            return -1L;
        }
        return this.writtenCounter.get(measurement).get();
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.ramBytesUsedByTimeAndColumns() + RamUsageEstimator.sizeOf((String[])this.measurements) + this.sizeOf(this.dataTypes, TSDataType.class) + this.sizeOf(this.inputLocations, InputLocation.class) + this.sizeOf(this.typeConvertors, Type.class) + RamUsageEstimator.sizeOfMap(this.writtenCounter, (long)RamUsageEstimator.shallowSizeOfInstance(AtomicLong.class));
    }
}

