/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.schemaregion;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.pipe.datastructure.queue.listening.AbstractPipeListeningQueue;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.PipeSnapshotEvent;
import org.apache.iotdb.commons.pipe.event.PipeWritePlanEvent;
import org.apache.iotdb.commons.pipe.source.IoTDBNonDataRegionSource;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionSnapshotEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.metric.overview.PipeDataNodeSinglePipeMetrics;
import org.apache.iotdb.db.pipe.metric.schema.PipeSchemaRegionSourceMetrics;
import org.apache.iotdb.db.pipe.source.schemaregion.PipePlanPatternParseVisitor;
import org.apache.iotdb.db.pipe.source.schemaregion.SchemaRegionListeningFilter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.write.AlterTimeSeriesNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeOperateSchemaQueueNode;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class IoTDBSchemaRegionSource
extends IoTDBNonDataRegionSource {
    public static final PipePlanPatternParseVisitor PATTERN_PARSE_VISITOR = new PipePlanPatternParseVisitor();
    private SchemaRegionId schemaRegionId;
    private Set<PlanNodeType> listenedTypeSet = new HashSet<PlanNodeType>();

    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) throws Exception {
        if (IoTDBDescriptor.getInstance().getConfig().getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.simple.SimpleConsensus")) {
            throw new PipeException("IoTDBSchemaRegionExtractor does not transferring events under simple consensus");
        }
        super.customize(parameters, configuration);
        this.schemaRegionId = new SchemaRegionId(this.regionId);
        this.listenedTypeSet = SchemaRegionListeningFilter.parseListeningPlanTypeSet(parameters);
        PipeSchemaRegionSourceMetrics.getInstance().register(this);
        PipeDataNodeSinglePipeMetrics.getInstance().register(this);
    }

    public void start() throws Exception {
        if (!PipeDataNodeAgent.runtime().isSchemaLeaderReady(this.schemaRegionId) || this.hasBeenStarted.get() || this.hasBeenClosed.get()) {
            return;
        }
        if (PipeDataNodeAgent.runtime().increaseAndGetSchemaListenerReferenceCount(this.schemaRegionId) == 1) {
            SchemaRegionConsensusImpl.getInstance().write((ConsensusGroupId)this.schemaRegionId, (IConsensusRequest)new PipeOperateSchemaQueueNode(new PlanNodeId(""), true));
        } else if (!PipeDataNodeAgent.runtime().schemaListener(this.schemaRegionId).isOpened()) {
            PipeDataNodeAgent.runtime().decreaseAndGetSchemaListenerReferenceCount(this.schemaRegionId);
            return;
        }
        super.start();
    }

    protected boolean needTransferSnapshot() {
        return PipeSchemaRegionSnapshotEvent.needTransferSnapshot(this.listenedTypeSet);
    }

    protected void triggerSnapshot() {
        try {
            SchemaRegionConsensusImpl.getInstance().triggerSnapshot((ConsensusGroupId)this.schemaRegionId, true);
        }
        catch (ConsensusException e) {
            throw new PipeException("Exception encountered when triggering schema region snapshot.", (Throwable)e);
        }
    }

    public synchronized EnrichedEvent supply() throws Exception {
        return PipeDataNodeAgent.runtime().isSchemaLeaderReady(this.schemaRegionId) ? super.supply() : null;
    }

    protected long getMaxBlockingTimeMs() {
        return 0L;
    }

    protected Optional<PipeWritePlanEvent> trimRealtimeEventByPipePattern(PipeWritePlanEvent event) {
        return ((Optional)PATTERN_PARSE_VISITOR.process(((PipeSchemaRegionWritePlanEvent)event).getPlanNode(), this.pipePattern)).map(planNode -> new PipeSchemaRegionWritePlanEvent((PlanNode)planNode, event.isGeneratedByPipe()));
    }

    protected AbstractPipeListeningQueue getListeningQueue() {
        return PipeDataNodeAgent.runtime().schemaListener(this.schemaRegionId);
    }

    protected boolean isTypeListened(PipeWritePlanEvent event) {
        PlanNode planNode = ((PipeSchemaRegionWritePlanEvent)event).getPlanNode();
        return this.listenedTypeSet.contains((Object)(planNode.getType() == PlanNodeType.ALTER_TIME_SERIES && ((AlterTimeSeriesNode)planNode).isAlterView() ? PlanNodeType.ALTER_LOGICAL_VIEW : planNode.getType()));
    }

    protected void confineHistoricalEventTransferTypes(PipeSnapshotEvent event) {
        ((PipeSchemaRegionSnapshotEvent)event).confineTransferredTypes(this.listenedTypeSet);
    }

    public synchronized void close() throws Exception {
        if (this.hasBeenClosed.get()) {
            return;
        }
        this.hasBeenClosed.set(true);
        if (!this.hasBeenStarted.get()) {
            return;
        }
        super.close();
        if (!this.listenedTypeSet.isEmpty()) {
            PipeDataNodeAgent.runtime().decreaseAndGetSchemaListenerReferenceCount(this.schemaRegionId);
        }
        if (Objects.nonNull(this.taskID)) {
            PipeSchemaRegionSourceMetrics.getInstance().deregister(this.taskID);
        }
    }
}

