/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.filter.factory;

import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.operator.BinaryFilterOperators;
import org.apache.tsfile.read.filter.operator.BooleanFilterOperators;
import org.apache.tsfile.read.filter.operator.DoubleFilterOperators;
import org.apache.tsfile.read.filter.operator.FloatFilterOperators;
import org.apache.tsfile.read.filter.operator.IntegerFilterOperators;
import org.apache.tsfile.read.filter.operator.LongFilterOperators;
import org.apache.tsfile.read.filter.operator.StringFilterOperators;
import org.apache.tsfile.read.filter.operator.ValueIsNotNullOperator;
import org.apache.tsfile.read.filter.operator.ValueIsNullOperator;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RegexUtils;

public class ValueFilterApi {
    public static final int DEFAULT_MEASUREMENT_INDEX = 0;
    private static final String CONSTANT_CANNOT_BE_NULL_MSG = " constant cannot be null";
    public static final String CANNOT_PUSH_DOWN_MSG = " operator can not be pushed down.";

    private ValueFilterApi() {
    }

    public static Filter gt(int measurementIndex, Object value, TSDataType type) {
        Objects.requireNonNull(value, CONSTANT_CANNOT_BE_NULL_MSG);
        switch (type) {
            case BOOLEAN: {
                return new BooleanFilterOperators.ValueGt(measurementIndex, (Boolean)value);
            }
            case INT32: 
            case DATE: {
                return new IntegerFilterOperators.ValueGt(measurementIndex, (Integer)value);
            }
            case INT64: 
            case TIMESTAMP: {
                return new LongFilterOperators.ValueGt(measurementIndex, (Long)value);
            }
            case DOUBLE: {
                return new DoubleFilterOperators.ValueGt(measurementIndex, (Double)value);
            }
            case FLOAT: {
                return new FloatFilterOperators.ValueGt(measurementIndex, ((Float)value).floatValue());
            }
            case TEXT: 
            case BLOB: {
                return new BinaryFilterOperators.ValueGt(measurementIndex, (Binary)value);
            }
            case STRING: {
                return new StringFilterOperators.ValueGt(measurementIndex, (Binary)value);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }

    public static Filter gtEq(int measurementIndex, Object value, TSDataType type) {
        Objects.requireNonNull(value, CONSTANT_CANNOT_BE_NULL_MSG);
        switch (type) {
            case BOOLEAN: {
                return new BooleanFilterOperators.ValueGtEq(measurementIndex, (Boolean)value);
            }
            case INT32: 
            case DATE: {
                return new IntegerFilterOperators.ValueGtEq(measurementIndex, (Integer)value);
            }
            case INT64: 
            case TIMESTAMP: {
                return new LongFilterOperators.ValueGtEq(measurementIndex, (Long)value);
            }
            case DOUBLE: {
                return new DoubleFilterOperators.ValueGtEq(measurementIndex, (Double)value);
            }
            case FLOAT: {
                return new FloatFilterOperators.ValueGtEq(measurementIndex, ((Float)value).floatValue());
            }
            case TEXT: 
            case BLOB: {
                return new BinaryFilterOperators.ValueGtEq(measurementIndex, (Binary)value);
            }
            case STRING: {
                return new StringFilterOperators.ValueGtEq(measurementIndex, (Binary)value);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }

    public static Filter lt(int measurementIndex, Object value, TSDataType type) {
        Objects.requireNonNull(value, CONSTANT_CANNOT_BE_NULL_MSG);
        switch (type) {
            case BOOLEAN: {
                return new BooleanFilterOperators.ValueLt(measurementIndex, (Boolean)value);
            }
            case INT32: 
            case DATE: {
                return new IntegerFilterOperators.ValueLt(measurementIndex, (Integer)value);
            }
            case INT64: 
            case TIMESTAMP: {
                return new LongFilterOperators.ValueLt(measurementIndex, (Long)value);
            }
            case DOUBLE: {
                return new DoubleFilterOperators.ValueLt(measurementIndex, (Double)value);
            }
            case FLOAT: {
                return new FloatFilterOperators.ValueLt(measurementIndex, ((Float)value).floatValue());
            }
            case TEXT: 
            case BLOB: {
                return new BinaryFilterOperators.ValueLt(measurementIndex, (Binary)value);
            }
            case STRING: {
                return new StringFilterOperators.ValueLt(measurementIndex, (Binary)value);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }

    public static Filter ltEq(int measurementIndex, Object value, TSDataType type) {
        Objects.requireNonNull(value, CONSTANT_CANNOT_BE_NULL_MSG);
        switch (type) {
            case BOOLEAN: {
                return new BooleanFilterOperators.ValueLtEq(measurementIndex, (Boolean)value);
            }
            case INT32: 
            case DATE: {
                return new IntegerFilterOperators.ValueLtEq(measurementIndex, (Integer)value);
            }
            case INT64: 
            case TIMESTAMP: {
                return new LongFilterOperators.ValueLtEq(measurementIndex, (Long)value);
            }
            case DOUBLE: {
                return new DoubleFilterOperators.ValueLtEq(measurementIndex, (Double)value);
            }
            case FLOAT: {
                return new FloatFilterOperators.ValueLtEq(measurementIndex, ((Float)value).floatValue());
            }
            case TEXT: 
            case BLOB: {
                return new BinaryFilterOperators.ValueLtEq(measurementIndex, (Binary)value);
            }
            case STRING: {
                return new StringFilterOperators.ValueLtEq(measurementIndex, (Binary)value);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }

    public static Filter eq(int measurementIndex, Object value, TSDataType type) {
        Objects.requireNonNull(value, CONSTANT_CANNOT_BE_NULL_MSG);
        switch (type) {
            case BOOLEAN: {
                return new BooleanFilterOperators.ValueEq(measurementIndex, (Boolean)value);
            }
            case INT32: 
            case DATE: {
                return new IntegerFilterOperators.ValueEq(measurementIndex, (Integer)value);
            }
            case INT64: 
            case TIMESTAMP: {
                return new LongFilterOperators.ValueEq(measurementIndex, (Long)value);
            }
            case DOUBLE: {
                return new DoubleFilterOperators.ValueEq(measurementIndex, (Double)value);
            }
            case FLOAT: {
                return new FloatFilterOperators.ValueEq(measurementIndex, ((Float)value).floatValue());
            }
            case TEXT: 
            case BLOB: {
                return new BinaryFilterOperators.ValueEq(measurementIndex, (Binary)value);
            }
            case STRING: {
                return new StringFilterOperators.ValueEq(measurementIndex, (Binary)value);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }

    public static Filter notEq(int measurementIndex, Object value, TSDataType type) {
        Objects.requireNonNull(value, CONSTANT_CANNOT_BE_NULL_MSG);
        switch (type) {
            case BOOLEAN: {
                return new BooleanFilterOperators.ValueNotEq(measurementIndex, (Boolean)value);
            }
            case INT32: 
            case DATE: {
                return new IntegerFilterOperators.ValueNotEq(measurementIndex, (Integer)value);
            }
            case INT64: 
            case TIMESTAMP: {
                return new LongFilterOperators.ValueNotEq(measurementIndex, (Long)value);
            }
            case DOUBLE: {
                return new DoubleFilterOperators.ValueNotEq(measurementIndex, (Double)value);
            }
            case FLOAT: {
                return new FloatFilterOperators.ValueNotEq(measurementIndex, ((Float)value).floatValue());
            }
            case TEXT: 
            case BLOB: {
                return new BinaryFilterOperators.ValueNotEq(measurementIndex, (Binary)value);
            }
            case STRING: {
                return new StringFilterOperators.ValueNotEq(measurementIndex, (Binary)value);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }

    public static Filter isNull(int measurementIndex) {
        return new ValueIsNullOperator(measurementIndex);
    }

    public static Filter isNotNull(int measurementIndex) {
        return new ValueIsNotNullOperator(measurementIndex);
    }

    public static Filter between(int measurementIndex, Object value1, Object value2, TSDataType type) {
        Objects.requireNonNull(value1, CONSTANT_CANNOT_BE_NULL_MSG);
        Objects.requireNonNull(value2, CONSTANT_CANNOT_BE_NULL_MSG);
        switch (type) {
            case BOOLEAN: {
                return new BooleanFilterOperators.ValueBetweenAnd(measurementIndex, (Boolean)value1, (Boolean)value2);
            }
            case INT32: 
            case DATE: {
                return new IntegerFilterOperators.ValueBetweenAnd(measurementIndex, (Integer)value1, (Integer)value2);
            }
            case INT64: 
            case TIMESTAMP: {
                return new LongFilterOperators.ValueBetweenAnd(measurementIndex, (Long)value1, (Long)value2);
            }
            case DOUBLE: {
                return new DoubleFilterOperators.ValueBetweenAnd(measurementIndex, (Double)value1, (Double)value2);
            }
            case FLOAT: {
                return new FloatFilterOperators.ValueBetweenAnd(measurementIndex, ((Float)value1).floatValue(), ((Float)value2).floatValue());
            }
            case TEXT: 
            case BLOB: {
                return new BinaryFilterOperators.ValueBetweenAnd(measurementIndex, (Binary)value1, (Binary)value2);
            }
            case STRING: {
                return new StringFilterOperators.ValueBetweenAnd(measurementIndex, (Binary)value1, (Binary)value2);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }

    public static Filter notBetween(int measurementIndex, Object value1, Object value2, TSDataType type) {
        Objects.requireNonNull(value1, CONSTANT_CANNOT_BE_NULL_MSG);
        Objects.requireNonNull(value2, CONSTANT_CANNOT_BE_NULL_MSG);
        switch (type) {
            case BOOLEAN: {
                return new BooleanFilterOperators.ValueNotBetweenAnd(measurementIndex, (Boolean)value1, (Boolean)value2);
            }
            case INT32: 
            case DATE: {
                return new IntegerFilterOperators.ValueNotBetweenAnd(measurementIndex, (Integer)value1, (Integer)value2);
            }
            case INT64: 
            case TIMESTAMP: {
                return new LongFilterOperators.ValueNotBetweenAnd(measurementIndex, (Long)value1, (Long)value2);
            }
            case DOUBLE: {
                return new DoubleFilterOperators.ValueNotBetweenAnd(measurementIndex, (Double)value1, (Double)value2);
            }
            case FLOAT: {
                return new FloatFilterOperators.ValueNotBetweenAnd(measurementIndex, ((Float)value1).floatValue(), ((Float)value2).floatValue());
            }
            case TEXT: 
            case BLOB: {
                return new BinaryFilterOperators.ValueNotBetweenAnd(measurementIndex, (Binary)value1, (Binary)value2);
            }
            case STRING: {
                return new StringFilterOperators.ValueNotBetweenAnd(measurementIndex, (Binary)value1, (Binary)value2);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }

    public static Filter like(int measurementIndex, String regexp, TSDataType type) {
        return ValueFilterApi.regexp(measurementIndex, RegexUtils.compileRegex(regexp), type);
    }

    public static Filter like(int measurementIndex, Pattern pattern, TSDataType type) {
        return ValueFilterApi.regexp(measurementIndex, pattern, type);
    }

    public static Filter notLike(int measurementIndex, String regexp, TSDataType type) {
        return ValueFilterApi.notRegexp(measurementIndex, RegexUtils.compileRegex(regexp), type);
    }

    public static Filter notLike(int measurementIndex, Pattern pattern, TSDataType type) {
        return ValueFilterApi.notRegexp(measurementIndex, pattern, type);
    }

    public static Filter regexp(int measurementIndex, String regexp, TSDataType type) {
        return ValueFilterApi.regexp(measurementIndex, RegexUtils.compileRegex(regexp), type);
    }

    public static Filter regexp(int measurementIndex, Pattern pattern, TSDataType type) {
        Objects.requireNonNull(pattern, CONSTANT_CANNOT_BE_NULL_MSG);
        switch (type) {
            case BOOLEAN: {
                return new BooleanFilterOperators.ValueRegexp(measurementIndex, pattern);
            }
            case INT32: 
            case DATE: {
                return new IntegerFilterOperators.ValueRegexp(measurementIndex, pattern);
            }
            case INT64: 
            case TIMESTAMP: {
                return new LongFilterOperators.ValueRegexp(measurementIndex, pattern);
            }
            case DOUBLE: {
                return new DoubleFilterOperators.ValueRegexp(measurementIndex, pattern);
            }
            case FLOAT: {
                return new FloatFilterOperators.ValueRegexp(measurementIndex, pattern);
            }
            case TEXT: 
            case BLOB: {
                return new BinaryFilterOperators.ValueRegexp(measurementIndex, pattern);
            }
            case STRING: {
                return new StringFilterOperators.ValueRegexp(measurementIndex, pattern);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }

    public static Filter notRegexp(int measurementIndex, String regexp, TSDataType type) {
        return ValueFilterApi.notRegexp(measurementIndex, RegexUtils.compileRegex(regexp), type);
    }

    public static Filter notRegexp(int measurementIndex, Pattern pattern, TSDataType type) {
        Objects.requireNonNull(pattern, CONSTANT_CANNOT_BE_NULL_MSG);
        switch (type) {
            case BOOLEAN: {
                return new BooleanFilterOperators.ValueNotRegexp(measurementIndex, pattern);
            }
            case INT32: 
            case DATE: {
                return new IntegerFilterOperators.ValueNotRegexp(measurementIndex, pattern);
            }
            case INT64: 
            case TIMESTAMP: {
                return new LongFilterOperators.ValueNotRegexp(measurementIndex, pattern);
            }
            case DOUBLE: {
                return new DoubleFilterOperators.ValueNotRegexp(measurementIndex, pattern);
            }
            case FLOAT: {
                return new FloatFilterOperators.ValueNotRegexp(measurementIndex, pattern);
            }
            case TEXT: 
            case BLOB: {
                return new BinaryFilterOperators.ValueNotRegexp(measurementIndex, pattern);
            }
            case STRING: {
                return new StringFilterOperators.ValueNotRegexp(measurementIndex, pattern);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }

    public static <T extends Comparable<T>> Filter in(int measurementIndex, Set<T> values, TSDataType type) {
        Objects.requireNonNull(values, CONSTANT_CANNOT_BE_NULL_MSG);
        switch (type) {
            case BOOLEAN: {
                return new BooleanFilterOperators.ValueIn(measurementIndex, values);
            }
            case INT32: 
            case DATE: {
                return new IntegerFilterOperators.ValueIn(measurementIndex, values);
            }
            case INT64: 
            case TIMESTAMP: {
                return new LongFilterOperators.ValueIn(measurementIndex, values);
            }
            case FLOAT: {
                return new FloatFilterOperators.ValueIn(measurementIndex, values);
            }
            case DOUBLE: {
                return new DoubleFilterOperators.ValueIn(measurementIndex, values);
            }
            case TEXT: 
            case BLOB: {
                return new BinaryFilterOperators.ValueIn(measurementIndex, values);
            }
            case STRING: {
                return new StringFilterOperators.ValueIn(measurementIndex, values);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }

    public static <T extends Comparable<T>> Filter notIn(int measurementIndex, Set<T> values, TSDataType type) {
        Objects.requireNonNull(values, CONSTANT_CANNOT_BE_NULL_MSG);
        switch (type) {
            case BOOLEAN: {
                return new BooleanFilterOperators.ValueNotIn(measurementIndex, values);
            }
            case INT32: 
            case DATE: {
                return new IntegerFilterOperators.ValueNotIn(measurementIndex, values);
            }
            case INT64: 
            case TIMESTAMP: {
                return new LongFilterOperators.ValueNotIn(measurementIndex, values);
            }
            case FLOAT: {
                return new FloatFilterOperators.ValueNotIn(measurementIndex, values);
            }
            case DOUBLE: {
                return new DoubleFilterOperators.ValueNotIn(measurementIndex, values);
            }
            case TEXT: 
            case BLOB: {
                return new BinaryFilterOperators.ValueNotIn(measurementIndex, values);
            }
            case STRING: {
                return new StringFilterOperators.ValueNotIn(measurementIndex, values);
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + type);
    }
}

