/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.subscription.meta.consumer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerMeta;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ConsumerGroupMeta {
    private String consumerGroupId;
    private long creationTime;
    private Map<String, Set<String>> topicNameToSubscribedConsumerIdSet = new ConcurrentHashMap<String, Set<String>>();
    private Map<String, ConsumerMeta> consumerIdToConsumerMeta = new ConcurrentHashMap<String, ConsumerMeta>();

    public ConsumerGroupMeta() {
    }

    public ConsumerGroupMeta(String consumerGroupId, long creationTime, ConsumerMeta firstConsumerMeta) {
        this();
        this.consumerGroupId = consumerGroupId;
        this.creationTime = creationTime;
        this.consumerIdToConsumerMeta.put(firstConsumerMeta.getConsumerId(), firstConsumerMeta);
    }

    public ConsumerGroupMeta deepCopy() {
        ConsumerGroupMeta copied = new ConsumerGroupMeta();
        copied.consumerGroupId = this.consumerGroupId;
        copied.creationTime = this.creationTime;
        copied.topicNameToSubscribedConsumerIdSet = new ConcurrentHashMap<String, Set<String>>(this.topicNameToSubscribedConsumerIdSet);
        copied.consumerIdToConsumerMeta = new ConcurrentHashMap<String, ConsumerMeta>(this.consumerIdToConsumerMeta);
        return copied;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public static Set<String> getTopicsUnsubByGroup(ConsumerGroupMeta currentMeta, ConsumerGroupMeta updatedMeta) {
        if (!Objects.equals(currentMeta.consumerGroupId, updatedMeta.consumerGroupId)) {
            return Collections.emptySet();
        }
        if (!Objects.equals(currentMeta.creationTime, updatedMeta.creationTime)) {
            return Collections.emptySet();
        }
        HashSet<String> unsubscribedTopicNames = new HashSet<String>();
        currentMeta.topicNameToSubscribedConsumerIdSet.keySet().forEach(topicName -> {
            if (!updatedMeta.topicNameToSubscribedConsumerIdSet.containsKey(topicName)) {
                unsubscribedTopicNames.add((String)topicName);
            }
        });
        return unsubscribedTopicNames;
    }

    public void addConsumer(ConsumerMeta consumerMeta) {
        this.consumerIdToConsumerMeta.put(consumerMeta.getConsumerId(), consumerMeta);
    }

    public void removeConsumer(String consumerId) {
        this.consumerIdToConsumerMeta.remove(consumerId);
        for (Map.Entry<String, Set<String>> entry : this.topicNameToSubscribedConsumerIdSet.entrySet()) {
            entry.getValue().remove(consumerId);
            if (!entry.getValue().isEmpty()) continue;
            this.topicNameToSubscribedConsumerIdSet.remove(entry.getKey());
        }
    }

    public boolean containsConsumer(String consumerId) {
        return this.consumerIdToConsumerMeta.containsKey(consumerId);
    }

    public boolean isEmpty() {
        return this.consumerIdToConsumerMeta.isEmpty();
    }

    public Set<String> getConsumersSubscribingTopic(String topic) {
        return this.topicNameToSubscribedConsumerIdSet.getOrDefault(topic, Collections.emptySet());
    }

    public Set<String> getTopicsSubscribedByConsumer(String consumerId) {
        HashSet<String> topics = new HashSet<String>();
        for (Map.Entry<String, Set<String>> topicNameToSubscribedConsumerId : this.topicNameToSubscribedConsumerIdSet.entrySet()) {
            if (!topicNameToSubscribedConsumerId.getValue().contains(consumerId)) continue;
            topics.add(topicNameToSubscribedConsumerId.getKey());
        }
        return topics;
    }

    public boolean isTopicSubscribedByConsumerGroup(String topic) {
        Set<String> subscribedConsumerIdSet = this.topicNameToSubscribedConsumerIdSet.get(topic);
        if (Objects.isNull(subscribedConsumerIdSet)) {
            return false;
        }
        return !subscribedConsumerIdSet.isEmpty();
    }

    public void addSubscription(String consumerId, Set<String> topics) {
        if (!this.consumerIdToConsumerMeta.containsKey(consumerId)) {
            throw new SubscriptionException(String.format("Failed to add subscription to consumer group meta: consumer %s does not exist in consumer group %s", consumerId, this.consumerGroupId));
        }
        for (String topic : topics) {
            this.topicNameToSubscribedConsumerIdSet.computeIfAbsent(topic, k -> new HashSet()).add(consumerId);
        }
    }

    public Set<String> removeSubscription(String consumerId, Set<String> topics) {
        if (!this.consumerIdToConsumerMeta.containsKey(consumerId)) {
            throw new SubscriptionException(String.format("Failed to remove subscription from consumer group meta: consumer %s does not exist in consumer group %s", consumerId, this.consumerGroupId));
        }
        HashSet<String> noSubscriptionTopicAfterRemoval = new HashSet<String>();
        for (String topic : topics) {
            if (!this.topicNameToSubscribedConsumerIdSet.containsKey(topic)) continue;
            this.topicNameToSubscribedConsumerIdSet.get(topic).remove(consumerId);
            if (!this.topicNameToSubscribedConsumerIdSet.get(topic).isEmpty()) continue;
            noSubscriptionTopicAfterRemoval.add(topic);
            this.topicNameToSubscribedConsumerIdSet.remove(topic);
        }
        return noSubscriptionTopicAfterRemoval;
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.consumerGroupId, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.creationTime, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.topicNameToSubscribedConsumerIdSet.size(), (OutputStream)outputStream);
        for (Map.Entry<String, Set<String>> entry : this.topicNameToSubscribedConsumerIdSet.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)outputStream);
            for (String id : entry.getValue()) {
                ReadWriteIOUtils.write((String)id, (OutputStream)outputStream);
            }
        }
        ReadWriteIOUtils.write((int)this.consumerIdToConsumerMeta.size(), (OutputStream)outputStream);
        for (Map.Entry<String, Object> entry : this.consumerIdToConsumerMeta.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
            ((ConsumerMeta)entry.getValue()).serialize(outputStream);
        }
    }

    public static ConsumerGroupMeta deserialize(InputStream inputStream) throws IOException {
        Object value;
        String key;
        int i;
        ConsumerGroupMeta consumerGroupMeta = new ConsumerGroupMeta();
        consumerGroupMeta.consumerGroupId = ReadWriteIOUtils.readString((InputStream)inputStream);
        consumerGroupMeta.creationTime = ReadWriteIOUtils.readLong((InputStream)inputStream);
        consumerGroupMeta.topicNameToSubscribedConsumerIdSet = new ConcurrentHashMap<String, Set<String>>();
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((InputStream)inputStream);
            value = new HashSet<String>();
            int innerSize = ReadWriteIOUtils.readInt((InputStream)inputStream);
            for (int j = 0; j < innerSize; ++j) {
                value.add(ReadWriteIOUtils.readString((InputStream)inputStream));
            }
            consumerGroupMeta.topicNameToSubscribedConsumerIdSet.put(key, (Set<String>)value);
        }
        consumerGroupMeta.consumerIdToConsumerMeta = new ConcurrentHashMap<String, ConsumerMeta>();
        size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((InputStream)inputStream);
            value = ConsumerMeta.deserialize(inputStream);
            consumerGroupMeta.consumerIdToConsumerMeta.put(key, (ConsumerMeta)value);
        }
        return consumerGroupMeta;
    }

    public static ConsumerGroupMeta deserialize(ByteBuffer byteBuffer) {
        Object value;
        String key;
        int i;
        ConsumerGroupMeta consumerGroupMeta = new ConsumerGroupMeta();
        consumerGroupMeta.consumerGroupId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        consumerGroupMeta.creationTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        consumerGroupMeta.topicNameToSubscribedConsumerIdSet = new ConcurrentHashMap<String, Set<String>>();
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            value = new HashSet<String>();
            int innerSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
            for (int j = 0; j < innerSize; ++j) {
                value.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
            }
            consumerGroupMeta.topicNameToSubscribedConsumerIdSet.put(key, (Set<String>)value);
        }
        consumerGroupMeta.consumerIdToConsumerMeta = new ConcurrentHashMap<String, ConsumerMeta>();
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            value = ConsumerMeta.deserialize(byteBuffer);
            consumerGroupMeta.consumerIdToConsumerMeta.put(key, (ConsumerMeta)value);
        }
        return consumerGroupMeta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConsumerGroupMeta that = (ConsumerGroupMeta)obj;
        return Objects.equals(this.consumerGroupId, that.consumerGroupId) && this.creationTime == that.creationTime && Objects.equals(this.topicNameToSubscribedConsumerIdSet, that.topicNameToSubscribedConsumerIdSet) && Objects.equals(this.consumerIdToConsumerMeta, that.consumerIdToConsumerMeta);
    }

    public int hashCode() {
        return Objects.hash(this.consumerGroupId, this.creationTime, this.topicNameToSubscribedConsumerIdSet, this.consumerIdToConsumerMeta);
    }

    public String toString() {
        return "ConsumerGroupMeta{consumerGroupId='" + this.consumerGroupId + "', creationTime=" + this.creationTime + ", topicNameToSubscribedConsumerIdSet=" + this.topicNameToSubscribedConsumerIdSet + ", consumerIdToConsumerMeta=" + this.consumerIdToConsumerMeta + "}";
    }
}

