/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;

public class ExceptionalCountDownLatch {
    private final CountDownLatch latch;
    private final AtomicReference<String> exceptionMessage = new AtomicReference();

    public ExceptionalCountDownLatch(int count) {
        this.latch = new CountDownLatch(count);
    }

    public void countDown() {
        this.latch.countDown();
    }

    public void countDownWithException(String message) {
        this.exceptionMessage.set(message);
        this.countDown();
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public boolean hasException() {
        return this.exceptionMessage.get() != null;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage.get();
    }
}

