/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.binary;

import java.nio.ByteBuffer;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;

public class WhenThenExpression
extends BinaryExpression {
    public WhenThenExpression(Expression leftExpression, Expression rightExpression) {
        super(leftExpression, rightExpression);
    }

    public WhenThenExpression(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public void setWhen(Expression expression) {
        this.leftExpression = expression;
    }

    public void setThen(Expression expression) {
        this.rightExpression = expression;
    }

    public Expression getWhen() {
        return this.leftExpression;
    }

    public Expression getThen() {
        return this.rightExpression;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.WHEN_THEN;
    }

    @Override
    protected String operator() {
        return "When Then";
    }

    @Override
    public String getExpressionStringInternal() {
        return "WHEN " + this.getWhen().getExpressionString() + " THEN " + this.getThen().getExpressionString();
    }

    @Override
    public String getOutputSymbolInternal() {
        String when = this.getWhen().getOutputSymbol();
        String then = this.getThen().getOutputSymbol();
        return "WHEN " + when + " THEN " + then;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitWhenThenExpression(this, context);
    }
}

