/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.jdbc.AbstractIoTDBJDBCResultSet;
import org.apache.iotdb.jdbc.IoTDBTracingInfo;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSTracingInfo;

public class IoTDBJDBCResultSet
extends AbstractIoTDBJDBCResultSet {
    private String operationType = "";
    private List<String> columns = null;
    private List<String> sgColumns = null;

    public IoTDBJDBCResultSet(Statement statement, List<String> columnNameList, List<String> columnTypeList, Map<String, Integer> columnNameIndex, boolean ignoreTimeStamp, TSIService.Iface client, String sql, long queryId, long sessionId, TSQueryDataSet dataset, TSTracingInfo tracingInfo, long timeout, String operationType, List<String> columns, List<String> sgColumns, BitSet aliasColumnMap) throws SQLException {
        super(statement, columnNameList, columnTypeList, columnNameIndex, ignoreTimeStamp, client, sql, queryId, sessionId, timeout, sgColumns, aliasColumnMap);
        this.ioTDBRpcDataSet.setTsQueryDataSet(dataset);
        if (tracingInfo != null) {
            this.ioTDBRpcTracingInfo = new IoTDBTracingInfo();
            this.ioTDBRpcTracingInfo.setTsTracingInfo(tracingInfo);
        }
        this.operationType = operationType;
        this.columns = columns;
        this.sgColumns = sgColumns;
    }

    public IoTDBJDBCResultSet(Statement statement, List<String> columnNameList, List<String> columnTypeList, Map<String, Integer> columnNameIndex, boolean ignoreTimeStamp, TSIService.Iface client, String sql, long queryId, long sessionId, TSQueryDataSet dataset, TSTracingInfo tracingInfo, long timeout, boolean isRpcFetchResult) throws SQLException {
        super(statement, columnNameList, columnTypeList, columnNameIndex, ignoreTimeStamp, client, sql, queryId, sessionId, timeout, isRpcFetchResult);
        this.ioTDBRpcDataSet.setTsQueryDataSet(dataset);
        if (tracingInfo != null) {
            this.ioTDBRpcTracingInfo = new IoTDBTracingInfo();
            this.ioTDBRpcTracingInfo.setTsTracingInfo(tracingInfo);
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        try {
            return this.ioTDBRpcDataSet.getLong(columnName);
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    protected boolean fetchResults() throws SQLException {
        try {
            return this.ioTDBRpcDataSet.fetchResults();
        }
        catch (IoTDBConnectionException | StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    protected boolean hasCachedResults() {
        return this.ioTDBRpcDataSet.hasCachedResults();
    }

    @Override
    protected void constructOneRow() {
        this.ioTDBRpcDataSet.constructOneRow();
    }

    @Override
    protected void checkRecord() throws SQLException {
        try {
            this.ioTDBRpcDataSet.checkRecord();
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    protected String getValueByName(String columnName) throws SQLException {
        try {
            return this.ioTDBRpcDataSet.getValueByName(columnName);
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    protected Object getObjectByName(String columnName) throws SQLException {
        try {
            return this.ioTDBRpcDataSet.getObjectByName(columnName);
        }
        catch (StatementExecutionException e) {
            throw new SQLException(e.getMessage());
        }
    }

    public boolean isIgnoreTimeStamp() {
        return this.ioTDBRpcDataSet.ignoreTimeStamp;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<String> getSgColumns() {
        return this.sgColumns;
    }
}

